<?php
function MSGway_Send_SMS($apiKey, $patternCode, $recipient, $variables) {
    $api_url = "https://api.msgway.com/send";

    $data = [
        "mobile" => $recipient,
        "method" => "sms",
        "templateID" => $patternCode,
        "params" => $variables
    ];

    $headers = [
        "apiKey: $apiKey",
        "Content-Type: application/json"
    ];

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $api_url,
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => $headers
    ]);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($ch);
    curl_close($ch);

    if ($curl_error) {
        return ['error' => true, 'message' => $curl_error];
    } elseif ($http_code != 200) {
        return ['error' => true, 'message' => "HTTP Code: $http_code", 'response' => $response];
    }

    return json_decode($response, true);
}
