<?php
include __DIR__ . "/ippanel.php";
include __DIR__ . "/kaveh_negar_api.php";
include __DIR__ . "/melipayamak.php";
include __DIR__ . "/sms.ir.php";
include __DIR__ . "/MSGway.php";

function get_key_value_pairs_from_redux_with_replacement($mobile, $code) {
    $key_value_pairs = get_option(SHOPI_OPTION)['key_value_repeater'];
    $result = array();
    foreach ($key_value_pairs['redux_repeater_data'] as $key =>  $item) {
        $item = $key_value_pairs;
        $item_val   = isset($item['value'][$key]) ? $item['value'][$key] : '';
        $item_key   = isset($item['key'][$key]) ? $item['key'][$key] : '';

        if (isset($item_val) && isset($item_val)) {
            $replaced_value = $item_val;
            $replaced_value = str_replace('{mobile}', $mobile, $replaced_value);
            $replaced_value = str_replace('{code}', $code, $replaced_value);

            if ($replaced_value[0] === '{' && $replaced_value[strlen($replaced_value) - 1] === '}') {
                $decoded_value = json_decode($replaced_value, true);
            } elseif ($replaced_value[0] === '[' && $replaced_value[strlen($replaced_value) - 1] === ']') {
                $decoded_value = json_decode($replaced_value, true);
            }

            if (isset($decoded_value)) {
                $result[$item_key] = $decoded_value;
            } else {
                $result[$item_key] = $replaced_value;
            }
        }
    }

    return $result;
}

function send_curl_request($api_url, $api_key, $data) {
    // Check if API URL is empty
    if (empty($api_url)) {
        return ['success' => false, 'message' => 'API URL is not defined.'];
    }

    // Initialize cURL
    $ch = curl_init();

    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true); // Use POST method
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data)); // Send data as JSON

    // Prepare headers
    $headers = [
        'Content-Type: application/json', // Set content type
    ];

    // Add API Key to headers if provided
    if (!empty($api_key)) {
        $headers[] = 'apikey: ' . $api_key; // Include API Key in the headers
    }

    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    // Execute cURL request
    $response = curl_exec($ch);

    // Check for cURL errors
    if (curl_errno($ch)) {
        $error_message = 'cURL Error: ' . curl_error($ch);
        curl_close($ch);
        return ['success' => false, 'message' => $error_message];
    }

    // Get HTTP response code
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Close cURL
    curl_close($ch);

    // Return the response and HTTP code
    return [
        'success' => $http_code >= 200 && $http_code < 300,
        'response' => $response,
        'http_code' => $http_code
    ];
}

function send_sms($recipient, $code) {
    global $shopi_options;

    // Ensure $to is a valid mobile number
    if (!preg_match('/^\+?[0-9]{10,15}$/', $recipient)) {
        return 'Invalid mobile number';
    }

    $type = $shopi_options['sms_api_type'] ?? 'kavenegar';


    $apiKey = $shopi_options['sms_api_key'] ?? '';
    $originator = $shopi_options['sms_originator'] ?? '';
    $patternCode = $shopi_options['sms_patern_code'] ?? 'loginverify';
    $token = $shopi_options['sms_token'] ?? '';


    try {
        switch ($type) {
            case 'kavenegar':
                $kavenegarApi = new KavenegarApi($apiKey);
                $result = $kavenegarApi->VerifyLookup($recipient, $code, null, null, $patternCode);
                $response = [
                    'status' => isset($result[0]->status) && $result[0]->status == 5 ? true : false
                ];
                break;
            case 'melipayamakcom':
                $variables = ["$code"];
                $result = Melipayamak_Send_Sms($apiKey, $patternCode, $recipient, $variables);
                $response = [
                    'status' => $result ? true : false
                ];
                break;
            case 'ippanel':
                $variables = ["$token" => $code];
                $result = Ippanel_Send_Sms($apiKey, $patternCode, $originator, $recipient, $variables);
                $response = [
                    'status' => $result ? true : false
                ];
                break;
            case 'sms.ir':
                $variables = [
                    "$token" => $code,
                ];
                $result = Smsir_Send_Sms($apiKey, $patternCode, $recipient, $variables);
                $response = [
                    'status' => $result ? true : false
                ];
                break;
            case 'MSGway':
                $variables = ["$code", "$code"];
                $patternCode = intval($patternCode);
                $result =    MSGway_Send_SMS($apiKey, $patternCode, $recipient, $variables);
                $response = [
                    'status' => $result ? true : false
                ];

                break;
            case 'custom':
                break;

            default:
                return 'Unknown SMS API type';
        }

        // Optional: Handle the response, e.g., log or check for success
        if ($response && isset($response['status']) && !$response['status']) {
            return $result;
        }

        return $result;
    } catch (Exception $e) {
        // Log or handle exceptions as needed
        return $result;
    }
}
