<?php
function Smsir_Send_Sms($apiKey, $patternCode, $recipient, $variables) {
    $curl = curl_init();

    $parametersJson = array_map(function ($name, $value) {
        return ['name' => $name, 'value' => $value];
    }, array_keys($variables), $variables);

    $postData = json_encode([
        'mobile' => $recipient,
        'templateId' => $patternCode,
        'parameters' => $parametersJson,
    ]);

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.sms.ir/v1/send/verify',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $postData,
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Accept: text/plain',
            'x-api-key: ' . $apiKey,
        ),
    ));

    $response = curl_exec($curl);

    if (curl_errno($curl)) {
        $error = curl_error($curl);
        curl_close($curl);
        return ['success' => false, 'message' => $error];
    }

    curl_close($curl);

    return ['success' => true, 'response' => $response];
}
