<?php
remove_action('set_comment_cookies', 'wp_set_comment_cookies');

// woocommerce_after_single_product_summary
remove_action("woocommerce_after_single_product_summary" , "woocommerce_output_product_data_tabs" , 10);
remove_action("woocommerce_after_single_product_summary" , "woocommerce_upsell_display" , 15);
remove_action("woocommerce_after_single_product_summary" , "woocommerce_output_related_products" , 20);

// woocommerce_single_product_summary
remove_action("woocommerce_single_product_summary", "woocommerce_template_single_title", 5);
remove_action("woocommerce_single_product_summary", "woocommerce_template_single_rating", 10);
remove_action("woocommerce_single_product_summary", "woocommerce_template_single_price", 10);
remove_action("woocommerce_single_product_summary", "woocommerce_template_single_excerpt", 20);
remove_action("woocommerce_single_product_summary", "woocommerce_template_single_add_to_cart", 30);
remove_action("woocommerce_single_product_summary", "woocommerce_template_single_meta", 40);
remove_action("woocommerce_single_product_summary", "woocommerce_template_single_sharing", 50);
remove_action('woocommerce_single_product_summary', array('WC_Structured_Data', 'generate_product_data'), 60);



function track_recently_viewed_products() {
    if (!is_singular(array('product', 'post'))) {
        return;
    }

    global $post;
    $product_id = $post->ID;
    $post_type = $post->post_type;

    // Check if the cookie exists
    if (isset($_COOKIE["recently_viewed_$post_type"])) {
        $recently_viewed = explode(',', $_COOKIE["recently_viewed_$post_type"]);

        // Remove duplicate product
        if (($key = array_search($product_id, $recently_viewed)) !== false) {
            unset($recently_viewed[$key]);
        }
    } else {
        $recently_viewed = [];
    }

    // Add the new product to the beginning of the list
    array_unshift($recently_viewed, $product_id);

    // Limit the number of products to 5
    if (count($recently_viewed) > 10) {
        array_pop($recently_viewed);
    }

    // Save the list as a cookie
    setcookie("recently_viewed_$post_type", implode(',', $recently_viewed), time() + 3600, COOKIEPATH, COOKIE_DOMAIN, false, true);
}
add_action('template_redirect', 'track_recently_viewed_products');


// Function to track recently viewed product categories
function track_recently_viewed_product_categories() {
    if (!is_tax('product_cat')) {
        return;
    }

    $term = get_queried_object();
    $term_id = $term->term_id;
    $taxonomy = 'product_cat';

    // Check if the cookie exists
    if (isset($_COOKIE["recently_viewed_$taxonomy"])) {
        $recently_viewed = explode(',', $_COOKIE["recently_viewed_$taxonomy"]);

        // Remove duplicate category
        if (($key = array_search($term_id, $recently_viewed)) !== false) {
            unset($recently_viewed[$key]);
        }
    } else {
        $recently_viewed = [];
    }

    // Add the new category to the beginning of the list
    array_unshift($recently_viewed, $term_id);

    // Limit the number of categories to 10
    if (count($recently_viewed) > 10) {
        array_pop($recently_viewed);
    }

    // Save the list as a cookie
    setcookie("recently_viewed_$taxonomy", implode(',', $recently_viewed), time() + 3600, COOKIEPATH, COOKIE_DOMAIN, false, true);
}
add_action('template_redirect', 'track_recently_viewed_product_categories');


function get_visited_list($meta_fav) {
    $meta_cookie = "recently_viewed_" . $meta_fav;
    if (isset($_COOKIE[$meta_cookie])) {
        $recently_viewed = explode(',', $_COOKIE[$meta_cookie]);
        $recently_viewed = array_filter($recently_viewed); // Remove empty values
        return $recently_viewed;
    }
    return [];
}