<?php
//ajax cart update quantity
add_action('wp_footer', 'bbloomer_add_cart_quantity_plus_minus');
function bbloomer_add_cart_quantity_plus_minus() {
    // Only run this on the single product page
    //if ( ! is_product() ) return;
    if (is_cart() || is_product()) {
?>
        <script type="text/javascript">
            jQuery(document).ready(function($) {
                var timeCart;
                $('.woocommerce').on('click', 'form.woocommerce-cart-form .plus,form.woocommerce-cart-form .minus', function(e) {
                    e.preventDefault();
                    clearTimeout(timeCart);
                    timeCart = setTimeout(function() {
                        jQuery('[name="update_cart"]').trigger('click');
                    }, 1000);

                    // Get current quantity values
                    var qty = $(this).parents('.product-quantity').find('.qty');
                    var btnupdate = $('form.woocommerce-cart-form').find('button[name="update_cart"]');
                    var val = parseInt(qty.val());
                    var max = qty.attr('max');
                    var min = qty.attr('min');
                    var step = parseInt(qty.attr('step'));

                    //console.log(max);
                    // Change the value if plus or minus
                    if ($(this).is('.plus')) {
                        if (max && (max <= val)) {
                            qty.val(max);
                        } else {
                            qty.val(val + step);
                        }
                    } else {
                        if (min && (min >= val)) {
                            qty.val(min);
                        } else if (val > 1) {
                            qty.val(val - step);
                        }
                    }
                    btnupdate.removeAttr('disabled');
                });

                $('form.cart').on('click', 'button.plus, button.minus', function(e) {
                    e.preventDefault();

                    // Get current quantity values
                    var qty = $(this).closest('form.cart').find('.qty');
                    var val = parseFloat(qty.val());
                    var max = parseFloat(qty.attr('max'));
                    var min = parseFloat(qty.attr('min'));
                    var step = parseFloat(qty.attr('step'));

                    // Change the value if plus or minus
                    if ($(this).is('.plus')) {
                        if (max && (max <= val)) {
                            qty.val(max);
                        } else {
                            qty.val(val + step);
                        }
                    } else {
                        if (min && (min >= val)) {
                            qty.val(min);
                        } else if (val >= 0) {
                            qty.val(val - step);
                        }
                    }
                });
            });
        </script>
    <?php
    }
}


add_action('wp_footer', 'bbloomer_cart_refresh_update_qty');
function bbloomer_cart_refresh_update_qty() {
    if (is_cart()) {
    ?>
        <script type="text/javascript">
            var timeCart;
            jQuery('div.woocommerce').on('input', 'input.qty', function() {
                clearTimeout(timeCart);
                timeCart = setTimeout(function() {
                    jQuery('[name="update_cart"]').trigger('click');
                }, 1000);
            });
        </script>
    <?php
    }
}


// remove coupon in cart
remove_action('woocommerce_before_checkout_form', 'woocommerce_checkout_coupon_form', 10);




//unset label billing_fields cart
// Apply to both billing and shipping fields
add_filter('woocommerce_billing_fields', 'customize_account_fields', 10, 1);
add_filter('woocommerce_shipping_fields', 'customize_account_fields', 10, 1);

function customize_account_fields($fields) {
    foreach ($fields as $key => $field) {
        if (isset($field['label'])) {
            // Set placeholder equal to label
            $fields[$key]['placeholder'] = $field['label'];

            // Optional: remove label completely
            // $fields[$key]['label'] = false;
        }
    }
    return $fields;
}



//unset label & and class to input billing_fields panel
add_filter('woocommerce_form_field_args', 'customize_billing_fields_args', 10, 3);
function customize_billing_fields_args($args, $key, $value) {
    if (isset($args['placeholder'])) {
        if (!isset($args['input_class']) || !is_array($args['input_class'])) {
            $args['input_class'] = [];
        }
        $args['input_class'][] = 'text-[13px] font-bold h-[50px] shadow-[0px_1px_0px_#e8ebf1] border-[1px] border-[#ebeff5] rounded-[9px] px-4 w-full focus:outline-none';

        if (!isset($args['label_class']) || !is_array($args['label_class'])) {
            $args['label_class'] = [];
        }
        $args['label_class'][] = 'hidden';
    }
    return $args;
}


// cart steps
add_action('woocommerce_before_cart', 'af_msc_before_cart_checkout', 0, 1);
add_action('woocommerce_before_cart_empty', 'af_msc_before_cart_checkout', 0, 1);
add_action('woocommerce_before_checkout_form', 'af_msc_before_cart_checkout', 0, 1);
add_action('woocommerce_before_thankyou', 'af_msc_before_cart_checkout', 0, 1);
add_action('woocommerce_before_order_receipt', 'af_msc_before_cart_checkout', 0, 1);
function af_msc_before_cart_checkout() {
    ?>
    <div class="flex items-center mb-24 list-step-cart a-md:mb-16">
        <a href="<?= wc_get_cart_url() ?>" class="item h-[4px] bg-secondary_bg w-full block relative <?= is_cart() ? 'active' : '' ?>">
            <span class="text text-[14px] text-[#495666] font-bold text-center absolute top-8 left-0 -translate-x-1/2 a-sm:text-[12px]">سبد
                خرید</span>
        </a>
        <a href="<?= wc_get_checkout_url() ?>" class="item h-[4px] bg-secondary_bg w-full block <?= is_checkout() && empty(is_wc_endpoint_url('order-received')) ? 'active' : '' ?>">
            <span class="text text-[14px] text-[#495666] font-bold text-center absolute top-8 left-0 -translate-x-1/2 a-sm:text-[12px]">انتخاب
                درگاه بانکی</span>
        </a>
        <span class="item h-[4px] bg-secondary_bg w-full block">
            <span class="text text-[14px] text-[#495666] font-bold text-center absolute top-8 left-0 -translate-x-1/2 a-sm:text-[12px]">تکمیل
                سفارش</span>
        </span>
        <span class="item h-[4px] bg-secondary_bg w-full block">
        </span>
    </div>
<?php
}







add_filter('woocommerce_checkout_fields', 'customize_billing_fields_based_on_global_options', 10, 1);
function customize_billing_fields_based_on_global_options($fields) {
    global $shopi_options; // Access global settings
    if ($shopi_options['disable_setting_billing_fields'] == "1") {
        return $fields;
    }


    // Define billing fields
    $billing_fields = [
        'billing_first_name' => 'نام',
        'billing_last_name'  => 'نام خانوادگی',
        'billing_company'    => 'شرکت',
        'billing_phone'      => 'تلفن',
        'billing_email'      => 'ایمیل',
        'billing_address_1'  => 'آدرس 1',
        'billing_address_2'  => 'آدرس 2',
        'billing_country'    => 'کشور',
        'billing_state'      => 'استان',
        'billing_city'       => 'شهر',
        'billing_postcode'   => 'کد پستی',
    ];
    foreach ($billing_fields as $field_id => $field_title) {
        if (isset($shopi_options[$field_id . '_enabled']) && !$shopi_options[$field_id . '_enabled']) {
            if ($field_id == 'billing_country') {
                $fields['billing'][$field_id]['class'][] = 'hidden';
            } else {
                unset($fields['billing'][$field_id]);
            }
        } else {
            if (isset($shopi_options[$field_id . '_label'])) {
                $fields['billing'][$field_id]['label'] = $shopi_options[$field_id . '_label'];
                $fields['billing'][$field_id]['placeholder'] = $shopi_options[$field_id . '_label'];
            }
            if (isset($shopi_options[$field_id . '_priority'])) {
                $fields['billing'][$field_id]['priority'] = $shopi_options[$field_id . '_priority'];
            }

            if (isset($shopi_options[$field_id . '_required'])) {
                $fields['billing'][$field_id]['required'] = $shopi_options[$field_id . '_required'];
            }
        }
    }

    return $fields;
}
