<?php

function get_product_discount_percentage($product_id) {
    $product = wc_get_product($product_id);

    if (!$product) {
        return 0;
    }

    if ($product->is_type('simple') && $product->is_on_sale()) {
        $regular_price = $product->get_regular_price();
        $sale_price = $product->get_sale_price();

        if ($regular_price && $sale_price) {
            return round(($regular_price - $sale_price) / $regular_price * 100);
        }
    }

    if ($product->is_type('variable')) {
        $max_discount = 0;

        $variations = $product->get_children();

        foreach ($variations as $variation_id) {
            $variation = wc_get_product($variation_id);

            if ($variation && $variation->is_on_sale()) {
                $regular_price = $variation->get_regular_price();
                $sale_price = $variation->get_sale_price();

                if ($regular_price && $sale_price) {
                    $discount_percentage = round(($regular_price - $sale_price) / $regular_price * 100);
                    $max_discount = max($max_discount, $discount_percentage);
                }
            }
        }

        return $max_discount;
    }

    return 0;
}

function get_simple_product_discount_percentage($product_id) {
    $product = wc_get_product($product_id);

    if ($product && $product->is_on_sale()) {
        $regular_price = $product->get_regular_price();
        $sale_price = $product->get_sale_price();
        if ($regular_price && $sale_price) {
            $discount_percentage = round(($regular_price - $sale_price) / $regular_price * 100);
            return $discount_percentage;
        } else {
            return 0;
        }
    } else {
        return 0;
    }
}

function get_status_tab($status_defult, $list) {
    $status = $_GET["status"] ?? $status_defult;
    if (isset($status) && !empty($status)) {
        if (array_key_exists($status, $list)) {
            $status_select = $status;
        } else {
            $status_select = $status_defult;
        }
    } else {
        $status_select = $status_defult;
    }
    return $status_select;
}

function get_image_user($id_or_email, $size) {
    if (is_numeric($id_or_email)) {
        $attachment_id = get_user_meta($id_or_email, 'pic_user', true);
        if (!empty($attachment_id)) {
            $image = wp_get_attachment_image($attachment_id, "full");
        } else {
            $image = get_avatar($id_or_email, $size);
        }
    } else {
        $image = get_avatar($id_or_email, $size);
    }
    return $image;
}

class Product_Stock_Filter_Widget extends WP_Widget {

	public function __construct() {
		parent::__construct(
			'product_stock_filter_widget',
			'فیلتر محصولات موجود',
			array('description' => 'نمایش فیلتر فقط محصولات موجود در ووکامرس')
		);
	}

	public function widget($args, $instance) {
		echo $args['before_widget'];

		$label = !empty($instance['label']) ? $instance['label'] : 'فقط محصولات موجود';
		$stock = isset($_GET['stock']) ? $_GET['stock'] : '';
		?>

		<form class="woocommerce-ordering woocommerce-ordering-side !block pb-[26px]" method="get">
			<label class="switch-button-wrap">
				<div class="switch-buttons-wrap ">
					<div class="switch-button flex items-center justify-between">
						<span class="text-[14px] text-[#495666] font-bold">
							<?php echo esc_html($label); ?>
						</span>

						<label for="shp-checkbox" class="btn w-[38px] h-[20px] flex items-center justify-end px-[4px] relative rounded-[10px] bg-[#f8f9fb] cursor-pointer <?php if ($stock == 'true') echo 'switch'; ?>">
							<span class="w-[10px] h-[10px] duration-300 rounded-full bg-[#969fae]"></span>
						</label>

						<input type="checkbox" name="stock" class="switch-input hidden" id="shp-checkbox" <?php checked($stock, 'true'); ?> value="true" />
						<?php wc_query_string_form_fields(null, array('orderby', 'submit', 'stock', 'paged', 'product-page')); ?>
					</div>
				</div>
				<input type="hidden" name="paged" value="1">
			</label>
		</form>
		<?php
		echo $args['after_widget'];
	}

	public function form($instance) {
		$label = !empty($instance['label']) ? $instance['label'] : 'فقط محصولات موجود';
		?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('label')); ?>">متن برچسب:</label>
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id('label')); ?>"
				name="<?php echo esc_attr($this->get_field_name('label')); ?>" type="text"
				value="<?php echo esc_attr($label); ?>">
		</p>
		<?php
	}

	public function update($new_instance, $old_instance) {
		$instance = [];
		$instance['label'] = sanitize_text_field($new_instance['label']);
		return $instance;
	}
}


function fatehi_register_product_stock_filter_widget() {
	register_widget('Product_Stock_Filter_Widget');
}
add_action('widgets_init', 'fatehi_register_product_stock_filter_widget');
