<?php
add_action('init', 'ts_custom_add_custom_endpoint');
function ts_custom_add_custom_endpoint() {
    add_rewrite_endpoint('wishlist', EP_ROOT | EP_PAGES);
    add_rewrite_endpoint('comment', EP_ROOT | EP_PAGES);
    add_rewrite_endpoint('visited', EP_ROOT | EP_PAGES);
    add_rewrite_endpoint('newsletter', EP_ROOT | EP_PAGES);
}


/**
 * 2. Add new query var
 */
add_filter('woocommerce_get_query_vars', 'ts_custom_wishlist_query_vars', 0);
function ts_custom_wishlist_query_vars($vars) {
    $vars[] = 'wishlist';
    $vars[] = 'comment';
    $vars[] = 'visited';
    $vars[] = 'tickets';
    return $vars;
}


/**
 * 3. Insert the new endpoint into the My Account menu
 */
add_filter('woocommerce_account_menu_items', 'custom_add_custom_link_my_account');
function custom_add_custom_link_my_account($items) {
    $items['wishlist'] = 'علاقه مندی های من ';
    $items['comment'] = 'نظرات من ';
    // $items['visited'] = 'آخرین بازدیدها';
    // $items['tickets'] = 'تیکت های پشتیبانی';

    return $items;
}



/**
 * @important-note	"add_action" must follow 'woocommerce_account_{your-endpoint-slug}_endpoint' format
 */
add_action("woocommerce_account_wishlist_endpoint", function () {
    get_template_part("template-parts/my-account/wishlist");
});
add_action("woocommerce_account_visited_endpoint", function () {
    get_template_part("template-parts/my-account/visited");
});
add_action("woocommerce_account_comment_endpoint", function () {
    get_template_part("template-parts/my-account/comment");
});
add_action("woocommerce_account_tickets_endpoint", function () {
    get_template_part("template-parts/my-account/tickets");
});


// rename endpoint my-account 
function custom_account_menu_items($items) {
    $items['edit-address'] = 'آدرس های من ';
    $items['edit-account'] = 'اطلاعات حساب کاربری';
    $items['customer-logout'] = 'خروج';
    unset($items['customer-logout']);

    return $items;
}
add_filter('woocommerce_account_menu_items', 'custom_account_menu_items');


// unset tab downloads
function custom_my_account_menu_items($items) {
    unset($items['downloads']);
    return $items;
}
add_filter('woocommerce_account_menu_items', 'custom_my_account_menu_items');


//filler order my-account
add_filter('woocommerce_my_account_my_orders_query', 'search_orders_by_id', 20, 1);
function search_orders_by_id($args) {
    $search = get_query_var('search');
    // $status = $_GET["status"] ?? "wc-processing";
    // if (isset($status) && !empty($status)) {
    //     if (array_key_exists($status, wc_get_order_statuses())) {
    //         $status_select = $status;
    //     } else {
    //         $status_select = "wc-processing";
    //     }
    // } else {
    //     $status_select = "wc-processing";
    // }
    // $args['post_status'] = [$status_select];

    if (isset($search) && !empty($search)) {
        $args["s"] = "$search";
    }

    return $args;
}

add_filter('document_title_parts', 'custom_account_endpoint_title');
function custom_account_endpoint_title($title) {
    global $wp_query;

    if (isset($wp_query->query_vars['wishlist'])) {
        $title['title'] = 'علاقه‌مندی‌های من';
    } elseif (isset($wp_query->query_vars['comment'])) {
        $title['title'] = 'نظرات من';
    } elseif (isset($wp_query->query_vars['visited'])) {
        $title['title'] = 'آخرین بازدیدها';
    } elseif (isset($wp_query->query_vars['tickets'])) {
        $title['title'] = 'تیکت‌های پشتیبانی';
    }

    return $title;
}
