<?php
//shop_per_page
add_filter('loop_shop_per_page', 'custom_loop_shop_per_page', 20);
function custom_loop_shop_per_page($cols) {
  global $shopi_options; // Access global settings
  return $shopi_options['loop_shop_per_page_shop'] ? intval($shopi_options['loop_shop_per_page_shop']) : 8;
}

add_filter('woocommerce_pagination_args', 'custom_woocommerce_pagination_args');
function custom_woocommerce_pagination_args($args) {
  $args['end_size'] = 3;
  $args['mid_size'] = 0;
  return $args;
}

// Add Sidebar for Shop
register_sidebar(array(
  'name' => 'سایدبار فروشگاه',
  'id' => 'sidebar_shop',
  'before_widget' => '<div id="%1$s" class="accordion accordion-group widget widget-side mb-[20px] border-[1px] border-[rgb(226,244,237)] rounded-[12px] px-[26px] pt-[37px] max-xl:py-[25px] max-xl:px-[15px] %2$s" data-closeall="true" data-defaultstate="open">',
  'after_widget' => '</div>',
  'before_title' => '<div class="widget-title accordion-head cursor-pointer title"><div class="head flex items-center justify-between"><span class="text-[14px]">',
  'after_title' => '</span><span class="icn">
                  <span class="icn">
                                <svg class="">
                                    <use xlink:href="#arrow-left-wave-icon"></use>
                                </svg>
                            </span></div></div>',
));

// remove sidebar defaults sidebar
function bbloomer_remove_sidebar_product_pages() {
  if (is_product()) {
    remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);
  }
}


// remove widgets-block-editor
add_action('after_setup_theme', 'example_theme_support');
function example_theme_support() {
  remove_theme_support('widgets-block-editor');
}



//instock/outofstock in shop page
add_action('pre_get_posts', 'filter_press_tax');

function filter_press_tax($query) {
  if ($query->is_main_query()) {
    if (isset($_GET['stock'])) {
      $stock = $_GET['stock'];
      if ($stock == 'true') :
        $query->set('meta_query', array(
          array(
            'key' => '_stock_status',
            'value' => 'instock',
            'compare' => '=',
          ),
        ));
      endif;
    }
  }
  return;
}

add_action('in_widget_form', function($widget, $return, $instance) {
    $accordion_open_c = isset($instance['accordion_open_c']) ? $instance['accordion_open_c'] : 0;

    ?>
    <p>
        <input class="checkbox" type="checkbox" <?php checked($accordion_open_c, 1); ?> id="<?php echo $widget->get_field_id('accordion_open_c'); ?>" name="<?php echo $widget->get_field_name('accordion_open_c'); ?>" value="1">
        <label for="<?php echo $widget->get_field_id('accordion_open_c'); ?>">اکاردون باز باشد ؟</label>
    </p>
    <?php
}, 10, 3);


add_filter('widget_update_callback', function($instance, $new_instance, $old_instance, $widget) {
    $instance['accordion_open_c'] = !empty($new_instance['accordion_open_c']) ? 1 : 0;
    return $instance;
}, 10, 4);


add_filter('dynamic_sidebar_params', function($params) {
    global $wp_registered_widgets;

    $widget_id = $params[0]['widget_id'];
    $sidebar_id = $params[0]['id'];

    if (!in_array($sidebar_id, ['sidebar_shop', 'sidebar_blog'])) {
        return $params; // فقط سایدبارهای مورد نظر
    }

    $widget_obj = $wp_registered_widgets[$widget_id] ?? null;
    if (!$widget_obj || !isset($widget_obj['callback'][0])) return $params;

    $widget_instance = $widget_obj['callback'][0];
    $instances = get_option('widget_' . $widget_instance->id_base, []);

    $number = $params[1]['number'] ?? null; // استفاده مستقیم از number در params
    $accordion_class = 'accordion-closed'; // پیش‌فرض بسته

    if (is_numeric($number) && isset($instances[$number]['accordion_open_c']) && $instances[$number]['accordion_open_c']) {
        $accordion_class = 'accordion-open';
    }

    // اضافه کردن کلاس دلخواه + وضعیت اکاردئون
    $params[0]['before_widget'] = preg_replace(
        '/class="([^"]*)"/',
        'class="$1 my-custom-widget '.$accordion_class.'"',
        $params[0]['before_widget']
    );

    return $params;
});

