<?php
$time =  reading_time(get_the_ID());
$show_read_time = get_query_var('show_read_time', 'yes');
?>
<article class="item-blog-index ">
    <a href="<?php the_permalink() ?>" class="!flex bg-[#eaf2fb] rounded-[28px] tab:rounded-[8px] h-[270px] w-full mb-9 flex a-lg:mb-4 box-img-post tab:h-[200px] overflow-hidden">
        <?php if (has_post_thumbnail()) {
            the_post_thumbnail('full', array('class' => 'w-full h-full object-cover transition-3s'));
        } else {
            if (class_exists('WooCommerce')) {
                echo wc_placeholder_img('full', ['class' => 'object-cover']);
            }
        } ?>
    </a>
    <h2>
        <a href="<?php the_permalink() ?>" class='title text-[19px] text-[#273039] font-bold line-clamp-1 mb-6 title a-lg:text-[15px] a-lg:mb-3 transition-3s'>
            <?php the_title() ?>
        </a>
    </h2>
    <div class="flex items-start gap-5">
        <?php if ($show_read_time === 'yes') : ?>
        <span class='time text-[11px] text-[#84aa98] font-bold flex items-center justify-center flex-col bg-[#ebf8f2] rounded-[4px] min-w-[35px] px-1'>
            <span class='text-[21px] text-[#00a651]  font-bold'><?= $time ?></span>
            دقیقه
        </span>
        <?php endif; ?>
        <p class='excerpt text-[12px] text-[#83919e] font-bold line-clamp-2 leading-[2.1] text-justify'>
            <?= get_the_excerpt() ?>
        </p>
    </div>
</article>