<?php
global $woocommerce, $product;
$count_item = get_query_var('count_item');
?>
<div class="quantity-card box-quantity-cart-item border border-[#dfe4ed] rounded-[16px] flex items-stretch justify-between w-full absolute left-0 right-0 -bottom-[200%] h-full bg-white transition-3s z-10 tab:rounded-[10px] <?= is_shop() || is_tax() ? '' : 'tab:h-[38px] outline outline-4 outline-white' ?> <?= $count_item != 0 ? 'active' : '' ?>">
    <button class="increase-quantity px-[20px]">
        <svg class="fill-[#28313b] w-[11px] h-[11px]">
            <use xlink:href="#plus-icon">
            </use>
        </svg>
    </button>
    <?php
    if ($product->is_sold_individually()) {
        $product_quantity = sprintf('<input type="hidden" name="quantity" value="1" />');
    } else {
        $cart_item_qty = WC()->cart->get_cart_item_quantities()[$product->get_id()] ?? 0;
        $input_args = array(
            'input_name' => 'quantity',
            'input_value' => $count_item,
            'max_value' => $product->backorders_allowed() ? '' : $product->get_stock_quantity(),
            'min_value' => '1',
            'classes' => 'text-[18px] text-[#28313b] font-bold grow text-center focus:outline-none py-1 max-w-[70px]',
            'product_id' => $product->get_id()
        );

        $product_quantity = woocommerce_quantity_input($input_args, $product, false);
    }
    echo apply_filters('woocommerce_product_quantity_input', $product_quantity);
    ?>
    <button class="decrease-quantity px-[20px]">
        <svg class="fill-[#28313b] w-[11px] h-[3px]">
            <use xlink:href="#minus-icon">
            </use>
        </svg>
    </button>
</div>