<?php 
function af_register_blog_post_style_controls($widget){
            /**
         * ----------------------------
         * 🔹 استایل آیتم بلاگ
         * ----------------------------
         */
        $widget->start_controls_section('style_item_blog_index', [
            'label' => __('استایل آیتم بلاگ', 'af-theme'),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $widget->add_responsive_control(
            'card_width',
            [
                'label' => __('عرض کارت', 'af-theme'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => ['min' => 200, 'max' => 600, 'step' => 10],
                    '%'  => ['min' => 10, 'max' => 100, 'step' => 1],
                ],
                'selectors' => [
                    '{{WRAPPER}} .item-blog-index' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // پس‌زمینه
        $widget->add_control('item_blog_bg', [
            'label' => __('رنگ پس‌زمینه', 'af-theme'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .item-blog-index' => 'background-color: {{VALUE}};',
            ],
        ]);

        // گردی گوشه‌ها
        $widget->add_responsive_control('item_blog_border_radius', [
            'label' => __('انحنای گوشه‌ها', 'af-theme'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%'],
            'range' => [
                'px' => ['min' => 0, 'max' => 100],
                '%'  => ['min' => 0, 'max' => 100],
            ],
            'selectors' => [
                '{{WRAPPER}} .item-blog-index' => 'border-radius: {{SIZE}}{{UNIT}};',
            ],
        ]);

        // حاشیه
        $widget->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_blog_border',
                'label' => __('حاشیه', 'af-theme'),
                'selector' => '{{WRAPPER}} .item-blog-index',
            ]
        );

        // سایه
        $widget->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_blog_shadow',
                'label' => __('سایه', 'af-theme'),
                'selector' => '{{WRAPPER}} .item-blog-index',
            ]
        );

        // فاصله داخلی
        $widget->add_responsive_control('item_blog_padding', [
            'label' => __('فاصله داخلی (Padding)', 'af-theme'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .item-blog-index' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        // فاصله بیرونی
        $widget->add_responsive_control('item_blog_margin', [
            'label' => __('فاصله بیرونی (Margin)', 'af-theme'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .item-blog-index' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $widget->end_controls_section();


        /**
         * ----------------------------
         * 🔹 استایل عنوان پست
         * ----------------------------
         */
        $widget->start_controls_section('style_item_blog_title', [
            'label' => __('استایل عنوان', 'af-theme'),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        // رنگ متن
        $widget->add_responsive_control('item_blog_title_color', [
            'label' => __('رنگ متن', 'af-theme'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .item-blog-index .title' => 'color: {{VALUE}};',
            ],
        ]);

        // رنگ هاور
        $widget->add_control('item_blog_title_hover_color', [
            'label' => __('رنگ هنگام هاور', 'af-theme'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .item-blog-index .title:hover' => 'color: {{VALUE}};',
            ],
        ]);

        // تایپوگرافی
        $widget->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_blog_title_typography',
                'label' => __('تایپوگرافی', 'af-theme'),
                'selector' => '{{WRAPPER}} .item-blog-index .title',
            ]
        );

        // فاصله داخلی
        $widget->add_responsive_control('item_blog_title_padding', [
            'label' => __('فاصله داخلی (Padding)', 'af-theme'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors' => [
                '{{WRAPPER}} .item-blog-index .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        // فاصله خارجی
        $widget->add_responsive_control('item_blog_title_margin', [
            'label' => __('فاصله خارجی (Margin)', 'af-theme'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors' => [
                '{{WRAPPER}} .item-blog-index .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        // Line Clamp
        $widget->add_responsive_control('item_blog_title_line_clamp', [
            'label' => __('تعداد خطوط نمایش داده شده (Line Clamp)', 'af-theme'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'range' => ['' => ['min' => 1, 'max' => 5, 'step' => 1]],
            'default' => ['size' => 1],
            'selectors' => [
                '{{WRAPPER}} .item-blog-index .title' => '
                    display: -webkit-box;
                    -webkit-line-clamp: {{SIZE}};
                    -webkit-box-orient: vertical;
                    overflow: hidden;
                ',
            ],
        ]);

        $widget->end_controls_section();


        /**
         * ----------------------------
         * 🔹 استایل تصویر پست
         * ----------------------------
         */
        $widget->start_controls_section('style_item_blog_image', [
            'label' => __('استایل تصویر پست', 'af-theme'),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $widget->add_responsive_control('item_blog_image_border_margin', [
            'label' => __('فاصله خارجی (Margin)', 'af-theme'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .item-blog-index .box-img-post' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $widget->add_responsive_control('item_blog_image_border_radius', [
            'label' => __('گردی گوشه‌ها', 'af-theme'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%'],
            'range' => [
                'px' => ['min' => 0, 'max' => 100],
                '%'  => ['min' => 0, 'max' => 50],
            ],
            'selectors' => [
                '{{WRAPPER}} .item-blog-index .box-img-post' => 'border-radius: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .item-blog-index .box-img-post img' => 'border-radius: {{SIZE}}{{UNIT}};',
            ],
        ]);

        $widget->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_blog_image_shadow',
                'label' => __('سایه تصویر', 'af-theme'),
                'selector' => '{{WRAPPER}} .item-blog-index .box-img-post',
            ]
        );

        $widget->add_responsive_control('item_blog_image_height', [
            'label' => __('ارتفاع تصویر', 'af-theme'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%', 'vh'],
            'selectors' => [
                '{{WRAPPER}} .item-blog-index .box-img-post' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ]);

        $widget->end_controls_section();


        /**
         * ----------------------------
         * 🔹 استایل زمان و خلاصه پست
         * ----------------------------
         */
        $widget->start_controls_section('style_item_blog_info', [
            'label' => __('استایل زمان و خلاصه', 'af-theme'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $widget->add_control(
            'show_read_time',
            [
                'label' => __('نمایش زمان مطالعه', 'af-theme'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'af-theme'),
                'label_off' => __('مخفی', 'af-theme'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        // زمان
        $widget->add_control('time_bg_color', [
            'label' => __('رنگ پس‌زمینه زمان', 'af-theme'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .item-blog-index .time' => 'background-color: {{VALUE}};',
            ],
        ]);

        $widget->add_control('time_text_color', [
            'label' => __('رنگ متن عدد زمان', 'af-theme'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .item-blog-index .time span' => 'color: {{VALUE}};',
            ],
        ]);

        $widget->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'time_typography',
                'label' => __('تایپوگرافی زمان', 'af-theme'),
                'selector' => '{{WRAPPER}} .item-blog-index .time span',
            ]
        );

        $widget->add_responsive_control('time_padding', [
            'label' => __('فاصله داخلی زمان', 'af-theme'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .item-blog-index .time' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $widget->add_responsive_control('time_border_radius', [
            'label' => __('گردی گوشه‌ها', 'af-theme'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px','%'],
            'selectors' => [
                '{{WRAPPER}} .item-blog-index .time' => 'border-radius: {{SIZE}}{{UNIT}};',
            ],
        ]);

        // خلاصه
        $widget->add_control('excerpt_text_color', [
            'label' => __('رنگ متن خلاصه', 'af-theme'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .item-blog-index .excerpt' => 'color: {{VALUE}};',
            ],
        ]);

        $widget->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'excerpt_typography',
                'label' => __('تایپوگرافی متن خلاصه', 'af-theme'),
                'selector' => '{{WRAPPER}} .item-blog-index .excerpt',
            ]
        );

        $widget->add_responsive_control('excerpt_line_clamp', [
            'label' => __('تعداد خطوط خلاصه (Line Clamp)', 'af-theme'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'range' => ['' => ['min'=>1,'max'=>5,'step'=>1]],
            'selectors' => [
                '{{WRAPPER}} .item-blog-index .excerpt' => '
                    display: -webkit-box;
                    -webkit-line-clamp: {{SIZE}};
                    -webkit-box-orient: vertical;
                    overflow: hidden;
                ',
            ],
        ]);

        $widget->add_responsive_control('excerpt_margin', [
            'label' => __('فاصله خارجی خلاصه', 'af-theme'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .item-blog-index .excerpt' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $widget->end_controls_section();
}


if ( ! function_exists( 'af_add_style_controls' ) ) {
    /**
     * Dynamically add style controls to Elementor widgets.
     *
     * @param object       $widget         Elementor widget instance ($this)
     * @param string       $name           Unique ID for the controls group
     * @param string       $label          Label shown in Elementor panel
     * @param string|array $selectors      CSS selector(s) to apply styles
     * @param array        $features       Features to add (color, typography, background, border, radius, shadow, padding, margin, size, transition, flex)
     * @param array        $hover_features Features for hover state (color, background, border, shadow)
     * @param bool         $start_section  Whether to start a new controls section (default true)
     * @param bool         $end_section    Whether to end the controls section (default true)
     */
    function af_add_style_controls( $widget, $name, $label, $selectors, $features = [], $hover_features = [], $start_section = true, $end_section = true ) {

        // اطمینان از اینکه selectors همیشه array است
        if ( ! is_array( $selectors ) ) {
            $selectors = [ $selectors ];
        }

        // اضافه کردن {{WRAPPER}} به هر selector
        $selector_string = implode( ', ', array_map( function( $sel ) {
            return "{{WRAPPER}} $sel";
        }, $selectors ) );

        if ( $start_section ) {
            $widget->start_controls_section( $name . '_style_section', [
                'label' => $label,
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ] );
        }

        $has_hover = ! empty( $hover_features );
        if ( $has_hover ) {
            $widget->start_controls_tabs( $name . '_tabs' );
            $widget->start_controls_tab( $name . '_normal', [ 'label' => __( 'Normal', 'af-theme' ) ] );
        }

                // ================= Flex Controls ================= //
        if ( in_array( 'flex', $features, true ) ) {
            // جهت چینش
            $widget->add_responsive_control($name . '_flex_direction', [
                'label'   => __('جهت چینش', 'af-theme'),
                'type'    => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'row'            => ['title' => __('ردیف', 'af-theme'), 'icon' => 'eicon-arrow-left'],
                    'row-reverse'    => ['title' => __('ردیف معکوس', 'af-theme'), 'icon' => 'eicon-arrow-right'],
                    'column'         => ['title' => __('ستون', 'af-theme'), 'icon' => 'eicon-arrow-down'],
                    'column-reverse' => ['title' => __('ستون معکوس', 'af-theme'), 'icon' => 'eicon-arrow-up'],
                ],
                'selectors' => [ $selector_string => 'flex-direction: {{VALUE}};' ],
            ]);

            // تراز افقی
            $widget->add_responsive_control($name . '_justify_content', [
                'label'   => __('تراز افقی', 'af-theme'),
                'type'    => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start'    => ['title' => __('چپ', 'af-theme'), 'icon' => 'eicon-justify-start-h'],
                    'center'        => ['title' => __('وسط', 'af-theme'), 'icon' => 'eicon-justify-center-h'],
                    'flex-end'      => ['title' => __('راست', 'af-theme'), 'icon' => 'eicon-justify-end-h'],
                    'space-between' => ['title' => __('بین عناصر', 'af-theme'), 'icon' => 'eicon-justify-space-between-h'],
                    'space-around'  => ['title' => __('حاشیه‌دار', 'af-theme'), 'icon' => 'eicon-justify-space-around-h'],
                    'space-evenly'  => ['title' => __('Evenly', 'af-theme'), 'icon' => 'eicon-justify-space-evenly-h'],
                ],
                'selectors' => [ $selector_string => 'justify-content: {{VALUE}};' ],
            ]);

            // تراز عمودی
            $widget->add_responsive_control($name . '_align_items', [
                'label'   => __('تراز عمودی', 'af-theme'),
                'type'    => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => ['title' => __('بالا', 'af-theme'), 'icon' => 'eicon-align-start-v'],
                    'center'     => ['title' => __('وسط', 'af-theme'), 'icon' => 'eicon-align-center-v'],
                    'flex-end'   => ['title' => __('پایین', 'af-theme'), 'icon' => 'eicon-align-end-v'],
                    'stretch'    => ['title' => __('کشیده', 'af-theme'), 'icon' => 'eicon-align-stretch-v'],
                ],
                'selectors' => [ $selector_string => 'align-items: {{VALUE}};' ],
            ]);

            // Wrap
            $widget->add_responsive_control($name . '_flex_wrap', [
                'label'   => __('شکستن خطوط (Wrap)', 'af-theme'),
                'type'    => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'nowrap' => ['title' => __('بدون شکست', 'af-theme'), 'icon' => 'eicon-nowrap'],
                    'wrap'   => ['title' => __('شکستن خطوط', 'af-theme'), 'icon' => 'eicon-wrap'],
                ],
                'selectors' => [ $selector_string => 'flex-wrap: {{VALUE}};' ],
            ]);

            // فاصله بین آیتم‌ها
            $widget->add_responsive_control($name . '_gap_x', [
                'label' => __('فاصله افقی', 'af-theme'),
                'type'  => \Elementor\Controls_Manager::SLIDER,
                'selectors' => [ $selector_string => 'column-gap: {{SIZE}}{{UNIT}};' ],
            ]);

            $widget->add_responsive_control($name . '_gap_y', [
                'label' => __('فاصله عمودی', 'af-theme'),
                'type'  => \Elementor\Controls_Manager::SLIDER,
                'selectors' => [ $selector_string => 'row-gap: {{SIZE}}{{UNIT}};' ],
            ]);
        }

        // ================= Normal Controls ================= //
        if ( in_array( 'color', $features, true ) ) {
            $widget->add_control( $name . '_color', [
                'label'     => __( 'رنگ متن', 'af-theme' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [ $selector_string => 'color: {{VALUE}};' ],
            ] );
        }

        if ( in_array( 'fill', $features, true ) ) {
            $widget->add_control( $name . '_fill', [
                'label'     => __( 'رنگ fill', 'af-theme' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [ $selector_string => 'fill: {{VALUE}};' ],
            ] );
        }

        if ( in_array( 'typography', $features, true ) ) {
            $widget->add_group_control(
                \Elementor\Group_Control_Typography::get_type(),
                [
                    'name'     => $name . '_typography',
                    'label'    => __( 'تایپوگرافی', 'af-theme' ),
                    'selector' => $selector_string,
                ]
            );
        }

        if ( in_array( 'line-clamp', $features, true ) ) {
            $widget->add_responsive_control( $name . '_line_clamp', [
                'label'      => __( 'تعداد خطوط', 'af-theme' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                    ],
                ],
                'selectors'  => [
                    $selector_string => '
                        display: -webkit-box;
                        -webkit-box-orient: vertical;
                        overflow: hidden;
                        -webkit-line-clamp: {{SIZE}};
                    ',
                ],
            ] );
        }


        if ( in_array( 'background', $features, true ) ) {
            $widget->add_group_control(
                \Elementor\Group_Control_Background::get_type(),
                [
                    'name'     => $name . '_background',
                    'label'    => __( 'پس‌زمینه', 'af-theme' ),
                    'selector' => $selector_string,
                ]
            );
        }

        if ( in_array( 'border', $features, true ) ) {
            $widget->add_group_control(
                \Elementor\Group_Control_Border::get_type(),
                [
                    'name'     => $name . '_border',
                    'label'    => __( 'حاشیه', 'af-theme' ),
                    'selector' => $selector_string,
                ]
            );
        }

        if ( in_array( 'radius', $features, true ) ) {
            $widget->add_responsive_control( $name . '_border_radius', [
                'label'      => __( 'شعاع گوشه‌ها', 'af-theme' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [ $selector_string => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
            ] );
        }

        if ( in_array( 'shadow', $features, true ) ) {
            $widget->add_group_control(
                \Elementor\Group_Control_Box_Shadow::get_type(),
                [
                    'name'     => $name . '_shadow',
                    'label'    => __( 'سایه', 'af-theme' ),
                    'selector' => $selector_string,
                ]
            );
        }

        if ( in_array( 'padding', $features, true ) ) {
            $widget->add_responsive_control( $name . '_padding', [
                'label'      => __( 'فاصله داخلی', 'af-theme' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors'  => [ $selector_string => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
            ] );
        }

        if ( in_array( 'margin', $features, true ) ) {
            $widget->add_responsive_control( $name . '_margin', [
                'label'      => __( 'فاصله بیرونی', 'af-theme' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors'  => [ $selector_string => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
            ] );
        }

        if ( in_array( 'width', $features, true ) ) {
            $widget->add_responsive_control( $name . '_width', [
                'label'      => __( 'عرض', 'af-theme' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'vw' ],
                'selectors'  => [ $selector_string => 'width: {{SIZE}}{{UNIT}};' ],
            ] );
        }
        if ( in_array( 'min-width', $features, true ) ) {
            $widget->add_responsive_control( $name . '_min_width', [
                'label'      => __( 'حداقل عرض', 'af-theme' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'vw' ],
                'selectors'  => [ $selector_string => 'min-width: {{SIZE}}{{UNIT}};' ],
            ] );
        }
        if ( in_array( 'max-width', $features, true ) ) {
            $widget->add_responsive_control( $name . '_max_width', [
                'label'      => __( 'حداکثر عرض', 'af-theme' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'vw' ],
                'selectors'  => [ $selector_string => 'max-width: {{SIZE}}{{UNIT}};' ],
            ] );
        }

        if ( in_array( 'height', $features, true ) ) {
            $widget->add_responsive_control( $name . '_height', [
                'label'      => __( 'ارتفاع', 'af-theme' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'vh' ],
                'selectors'  => [ $selector_string => 'height: {{SIZE}}{{UNIT}};' ],
            ] );
        }
        if ( in_array( 'min-height', $features, true ) ) {
            $widget->add_responsive_control( $name . '_min_height', [
                'label'      => __( 'حداقل ارتفاع', 'af-theme' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'vh' ],
                'selectors'  => [ $selector_string => 'min-height: {{SIZE}}{{UNIT}};' ],
            ] );
        }
        if ( in_array( 'max-height', $features, true ) ) {
            $widget->add_responsive_control( $name . '_max_height', [
                'label'      => __( 'حداکثر ارتفاع', 'af-theme' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'vh' ],
                'selectors'  => [ $selector_string => 'max-height: {{SIZE}}{{UNIT}};' ],
            ] );
        }

        if ( in_array( 'size', $features, true ) ) {
            $widget->add_responsive_control( $name . '_width_height', [
                'label'      => __( 'سایز', 'af-theme' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'vw' ],
                'selectors'  => [ $selector_string => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};' ],
            ] );
        }

        if ( in_array( 'display', $features, true ) ) {
            $widget->add_responsive_control( $name . '_display', [
                'label'   => __( 'نمایش', 'af-theme' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'block'  => __( 'Block', 'af-theme' ),
                    'inline' => __( 'Inline', 'af-theme' ),
                    'flex'   => __( 'Flex', 'af-theme' ),
                    'none'   => __( 'None', 'af-theme' ),
                ],
                'selectors' => [ $selector_string => 'display: {{VALUE}};' ],
            ] );
        }

        if ( in_array( 'rotate', $features, true ) ) {
            $widget->add_responsive_control( $name . '_rotate', [
                'label'       => __( 'چرخش (درجه)', 'af-theme' ),
                'type'        => \Elementor\Controls_Manager::NUMBER,
                'min'         => 0,
                'max'         => 360,
                'step'        => 1,
                'default'     => 0,
                'selectors'   => [
                    $selector_string => 'transform: rotate({{VALUE}}deg);',
                ],
            ] );
        }




        if ( in_array( 'transition', $features, true ) ) {
            $widget->add_control( $name . '_transition', [
                'label'     => __( 'Transition', 'af-theme' ),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default'   => 'all 0.3s ease',
                'selectors' => [ $selector_string => 'transition: {{VALUE}};' ],
            ] );
        }


        // ================= Hover Controls ================= //
        if ( $has_hover ) {
            $widget->end_controls_tab();
            $widget->start_controls_tab( $name . '_hover', [ 'label' => __( 'Hover', 'af-theme' ) ] );

            foreach ( $hover_features as $feature ) {
                switch ( $feature ) {
                    case 'color':
                        $widget->add_control( $name . '_hover_color', [
                            'label'     => __( 'رنگ متن (Hover)', 'af-theme' ),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [ $selector_string . ':hover' => 'color: {{VALUE}};' ],
                        ]);
                        break;

                    case 'background':
                        $widget->add_control( $name . '_hover_background', [
                            'label'     => __( 'پس‌زمینه (Hover)', 'af-theme' ),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [ $selector_string . ':hover' => 'background-color: {{VALUE}};' ],
                        ]);
                        break;

                    case 'border':
                        $widget->add_group_control(
                            \Elementor\Group_Control_Border::get_type(),
                            [
                                'name'     => $name . '_hover_border',
                                'label'    => __( 'حاشیه (Hover)', 'af-theme' ),
                                'selector' => $selector_string . ':hover',
                            ]
                        );
                        break;

                    case 'shadow':
                        $widget->add_group_control(
                            \Elementor\Group_Control_Box_Shadow::get_type(),
                            [
                                'name'     => $name . '_hover_shadow',
                                'label'    => __( 'سایه (Hover)', 'af-theme' ),
                                'selector' => $selector_string . ':hover',
                            ]
                        );
                        break;
                }
            }

            $widget->end_controls_tab();
            $widget->end_controls_tabs();
        }

        if ( $end_section ) {
            $widget->end_controls_section();
        }
    }
}
