<?php
class Af_Newsletter_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'newsletter_form';
    }

    public function get_title() {
        return __('فرم خبرنامه', 'af-theme');
    }

    public function get_icon() {
        return 'eicon-mail';
    }

    public function get_categories() {
        return ['af-footer']; 
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'newsletter_section',
            [
                'label' => __('خبرنامه', 'af-theme'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'placeholder',
            [
                'label' => __('متن جایگزین ایمیل', 'af-theme'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'آدرس ایمیل خود را وارد نمایید.',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $placeholder = !empty($settings['placeholder']) ? $settings['placeholder'] : 'ایمیل خود را وارد کنید';

        $error = [];
        $success = '';

        if (isset($_POST["mailchimp_submit"]) && isset($_POST["token"]) && get_csrf_token() === $_POST["token"]) {
            $email = isset($_POST['email']) ? sanitize_email($_POST['email']) : '';

            if (!empty($email)) {
                if (is_email($email)) {
                    insert_mailchimp_subscriber($email); 
                    $success = "عضویت شما با موفقیت انجام شد";
                    regenerate_csrf_token();
                } else {
                    $error[] = "فرمت ایمیل اشتباه است";
                }
            } else {
                $error[] = "ایمیل نمی‌تواند خالی باشد";
            }
        }
        ?>
        <div class="relative box-news-letter">
            <form action="#mailchimp" method="post" id="mailchimp">
                <input name="email" type="email" placeholder="<?= esc_attr($placeholder) ?>" required>
                <button type="submit" name="mailchimp_submit">
                    <svg class="icon w-[9px] h-[9px] fill-white">
                        <use xlink:href="#arrow-left-wave-icon"></use>
                    </svg>
                </button>
                <?= csrf_field() ?> 
            </form>

            <?php if (!empty($success)) : ?>
                <span class="text-[13px] text-green-500 font-bold absolute -bottom-6 left-0">
                    <?= esc_html($success) ?>
                </span>
            <?php endif; ?>

            <?php if (!empty($error)) : ?>
                <ul class="text-[13px] text-red-500 font-bold absolute -bottom-6 left-0">
                    <?php foreach ($error as $err) : ?>
                        <li><?= esc_html($err) ?></li>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
        </div>
        <?php
    }
}
