<?php
global $shopi_options;
$error = [];
if (isset($_POST["mailchimp_submit"]) && isset($_POST["token"]) &&  get_csrf_token() == $_POST["token"]) {
    if (isset($email) && !empty($_POST['email'])) {
        $email = !empty($_POST['email']) ? sanitize_email($_POST['email']) :  '';
        if (is_email($email)) {
            insert_mailchimp_subscriber($email);
            $success = "عضویت شما با موفقت انجام شد";
            regenerate_csrf_token();
        } else {
            $error[] = "فرمت ایمیل اشتباه است";
        }
    } else {
        $error[] = "ایمیل نمی تواند خالی باشد";
    }
}
?>
<footer class="container 2xl pt-10 footer a-md:pt-6">
    <div class="info-footer pb-5">
        <div class="relative overflow-y-hidden overflow-x-clip">
            <?php if (isset($shopi_options['logo_wave_footer']['id']) && !empty($shopi_options['logo_wave_footer']['id'])) { ?>
                <div class="wave-footer">
                    <?= wp_get_attachment_image($shopi_options['logo_wave_footer']['id'], 'full', false, ['class' => 'max-h-[40px] mt-[70px] object-contain mr-auto max-w-[160px]']) ?>
                </div>
            <?php } ?>
            <div class="box-footer-description flex items-center gap-10 py-7 w-[80%] a-md:flex-col a-md:items-start a-md:gap-5 a-md:w-full a-md:py-4">
                <?php if (isset($shopi_options['logo_footer']['id']) && !empty($shopi_options['logo_footer']['id'])) { ?>
                    <?= wp_get_attachment_image($shopi_options['logo_footer']['id'], 'full', false, ['class' => 'object-contain max-w-[100px] max-h-[50px]']) ?>
                <?php } ?>
                <?php if (isset($shopi_options['description_short_footer']) && !empty($shopi_options['description_short_footer'])) { ?>
                    <p class="text-[13px] text-[#969fae] font-bold line-clamp-2 leading-[2.2] a-xl:line-clamp-4 text-justify">
                        <?= @esc_attr($shopi_options['description_short_footer']) ?>
                    </p>
                <?php } ?>
            </div>
        </div>
    </div>
    <?php if (isset($shopi_options['list_attr_footer']['redux_repeater_data']) && !empty($shopi_options['list_attr_footer']['redux_repeater_data'])) { ?>
        <div class="attr-footer border-t border-[#f1f2f7] py-7 a-md:py-4">
            <div class="flex items-center gap-4 a-xl:grid a-xl:grid-cols-3 a-md:grid-cols-2">
                <?php foreach ($shopi_options['list_attr_footer']['redux_repeater_data'] as $key => $value) {
                    $item = $shopi_options['list_attr_footer'];
                    $pic   = isset($item['pic'][$key]) ? $item['pic'][$key] : '';
                    $title   = isset($item['title'][$key]) ? $item['title'][$key] : '';
                    $sub_title   = isset($item['sub_title'][$key]) ? $item['sub_title'][$key] : '';
                ?>
                    <div class="item flex items-center gap-5 flex-1 a-md:gap-2">
                        <?php if (isset($pic['id']) && !empty($pic['id'])) { ?>
                            <?= wp_get_attachment_image($pic['id'], 'full', false, ['class' => 'w-[40px] h-[40px] object-contain']) ?>
                        <?php } ?>
                        <span class="flex flex-col gap-2">
                            <?php if (isset($title) && !empty($title)) { ?>
                                <h3 class="text-[14px] text-[#495666] font-bold line-clamp-1"><?= @esc_attr($title) ?></h3>
                            <?php } ?>
                            <?php if (isset($sub_title) && !empty($sub_title)) { ?>
                                <span class="text-[13px] text-[#969fae] font-bold line-clamp-1">
                                    <?= @esc_attr($sub_title) ?>
                                </span>
                            <?php } ?>
                        </span>
                    </div>
                <?php } ?>
            </div>
        </div>
    <?php } ?>
    <div class="footer-content border-t border-[#f1f2f7] py-12 flex gap-20 2xl:gap-10 a-xl:flex-col a-md:py-4">
        <div class="max-w-[464px] min-w-[464px] a-xl:max-w-full a-xl:min-w-full">
            <div class="flex items-center justify-between gap-3 mb-8 a-md:mb-4">
                <?php if (isset($shopi_options['title_footer']) && !empty($shopi_options['title_footer'])) { ?>
                    <?php if (is_front_page() || is_home()) : ?>
                        <h1 class="text-[17px] text-primary_text font-bold"><?= esc_attr($shopi_options['title_footer']) ?></h1>
                    <?php else : ?>
                        <span class="text-[17px] text-primary_text font-bold"><?= esc_attr($shopi_options['title_footer']) ?></span>
                    <?php endif; ?>
                <?php } ?>
                <?php if (!empty($shopi_options['link_access_footer']) && !empty($shopi_options['title_link_access_footer'])) { ?>
                    <a href="<?= @esc_attr($shopi_options['link_access_footer']) ?>" class="text-[13px] text-[#969fae] font-bold flex items-center gap-1 a-md:text-[#626264]">
                        <?= @esc_attr($shopi_options['title_link_access_footer']) ?>
                    </a>
                <?php } ?>
            </div>
            <?php if (isset($shopi_options['description_full_footer']) && !empty($shopi_options['description_full_footer'])) { ?>
                <p class="text-[13px] text-[#969fae] font-bold line-clamp-5 leading-[2.7] text-justify mb-12 a-xl:mb-4 a-md:leading-[2] a-md:text-[13px]">
                    <?= @esc_attr($shopi_options['description_full_footer']) ?>
                </p>
            <?php } ?>
            <div class="flex flex-col gap-3">
                <?php if (!empty($shopi_options['title_link_call_access_footer']) && !empty($shopi_options['link_call_access_footer'])) { ?>
                    <div class="flex items-center justify-between">
                        <?php if (isset($shopi_options['title_call_access_footer']) && !empty($shopi_options['title_call_access_footer'])) { ?>
                            <span class="text-[14px] text-[#969fae] font-bold a-md:text-[#626264]"><?= @esc_attr($shopi_options['title_call_access_footer']) ?></span>
                        <?php } ?>
                        <a href="<?= @esc_attr($shopi_options['link_call_access_footer']) ?>" class="flex items-center gap-3" rel="nofollow noopener noreferrer">
                            <span class="text-[20px] text-primary_text font-bold">
                                <?= title_generator($shopi_options['title_link_call_access_footer'], 'text-[17px] text-[#969fae] font-bold') ?>
                            </span>
                            <svg class="fill-[#969fae]  w-5 h-5">
                                <use xlink:href="#call-icon">
                                </use>
                            </svg>
                        </a>
                    </div>
                <?php } ?>
                <?php if (!empty($shopi_options['title_email_call_access_footer']) && !empty($shopi_options['link_email_access_footer'])) { ?>
                    <div class="flex items-center justify-between">
                        <?php if (isset($shopi_options['title_email_access_footer']) && !empty($shopi_options['title_email_access_footer'])) { ?>
                            <span class="text-[14px] text-[#969fae] font-bold a-md:text-[#626264]"><?= @esc_attr($shopi_options['title_email_access_footer']) ?></span>
                        <?php } ?>
                        <a href="<?= @esc_attr($shopi_options['link_email_access_footer']) ?>" class="flex items-center gap-3 text-[14px] text-[#969fae] font-bold" rel="nofollow noopener noreferrer" target="_blank">
                            <?= @esc_attr($shopi_options['title_email_call_access_footer']) ?>
                            <svg class="fill-[#969fae]  w-4 h-5">
                                <use xlink:href="#email-icon">
                                </use>
                            </svg>
                        </a>
                    </div>
                <?php } ?>
                <?php if (!empty($shopi_options['title_map_call_access_footer']) && !empty($shopi_options['link_map_access_footer'])) { ?>
                    <div class="flex items-center justify-between">
                        <?php if (isset($shopi_options['title_map_access_footer']) && !empty($shopi_options['title_map_access_footer'])) { ?>
                            <span class="text-[14px] text-[#969fae] font-bold a-md:text-[#626264]"><?= @esc_attr($shopi_options['title_map_access_footer']) ?></span>
                        <?php } ?>
                        <a href="<?= @esc_attr($shopi_options['link_map_access_footer']) ?>" class="flex items-center gap-3 text-[13px] text-[#969fae] font-bold" rel="nofollow noopener noreferrer" target="_blank">
                            <?= @esc_attr($shopi_options['title_map_call_access_footer']) ?>
                            <svg class="fill-[#969fae] w-4 h-5">
                                <use xlink:href="#map-icon">
                                </use>
                            </svg>
                        </a>
                    </div>
                <?php } ?>
            </div>
        </div>
        <div class="grow">
            <div class="mb-12 flex a-md:flex-col a-md:mb-6">
                <div class="flex grow gap-4 a-md:mb-7">
                    <?php if (isset($shopi_options['list_link_1_footer']) && !empty($shopi_options['list_link_1_footer'])) { ?>
                        <div class="flex-1">
                            <?php if (isset($shopi_options['title_list_link_1_footer']) && !empty($shopi_options['title_list_link_1_footer'])) { ?>
                                <span class="text-[13px] text-[#969fae] font-bold mb-11 flex a-md:mb-4 a-md:text-[#626264]">
                                    <?= @esc_attr($shopi_options['title_list_link_1_footer']) ?>
                                </span>
                            <?php } ?>
                            <ul class="flex flex-col gap-[19px] list-link-footer">
                                <?php
                                foreach ($shopi_options['list_link_1_footer']['redux_repeater_data'] as $key =>  $link) {
                                    $link = $shopi_options['list_link_1_footer'];
                                    $link_text   = isset($link['text'][$key]) ? $link['text'][$key] : '';
                                    $link_url    = isset($link['url'][$key]) && !empty($link['url'][$key]) ? $link['url'][$key] : '#';
                                    $link_target = isset($link['target'][$key]) ? $link['target'][$key] : '_self';
                                    $link_rel    = isset($link['rel'][$key]) ? $link['rel'][$key] : '';
                                    $link_flow   = isset($link['flow'][$key]) ? $link['flow'][$key] : '';
                                ?>
                                    <li>
                                        <a class="text-[13px] text-[#969fae] font-bold line-clamp-1" href="<?= esc_url($link_url); ?>" target="<?= esc_attr($link_target); ?>" rel="<?= esc_attr($link_rel); ?>" flow="<?= esc_attr($link_flow); ?>">
                                            <?= esc_html($link_text); ?>
                                        </a>
                                    </li>
                                <?php } ?>
                            </ul>
                        </div>
                    <?php } ?>
                    <?php if (isset($shopi_options['list_link_2_footer']) && !empty($shopi_options['list_link_2_footer'])) { ?>
                        <div class="flex-1">
                            <?php if (isset($shopi_options['title_list_link_2_footer']) && !empty($shopi_options['title_list_link_2_footer'])) { ?>
                                <span class="text-[13px] text-[#969fae] font-bold mb-11 flex a-md:mb-4 a-md:text-[#626264]">
                                    <?= @esc_attr($shopi_options['title_list_link_2_footer']) ?>
                                </span>
                            <?php } ?>
                            <ul class="flex flex-col gap-[19px] list-link-footer">
                                <?php
                                foreach ($shopi_options['list_link_2_footer']['redux_repeater_data'] as $key =>  $link) {
                                    $link = $shopi_options['list_link_2_footer'];
                                    $link_text   = isset($link['text'][$key]) ? $link['text'][$key] : '';
                                    $link_url    = isset($link['url'][$key]) && !empty($link['url'][$key]) ? $link['url'][$key] : '#';
                                    $link_target = isset($link['target'][$key]) ? $link['target'][$key] : '_self';
                                    $link_rel    = isset($link['rel'][$key]) ? $link['rel'][$key] : '';
                                    $link_flow   = isset($link['flow'][$key]) ? $link['flow'][$key] : '';
                                ?>
                                    <li>
                                        <a class="text-[13px] text-[#969fae] font-bold line-clamp-1" href="<?= esc_url($link_url); ?>" target="<?= esc_attr($link_target); ?>" rel="<?= esc_attr($link_rel); ?>" flow="<?= esc_attr($link_flow); ?>">
                                            <?= esc_html($link_text); ?>
                                        </a>
                                    </li>
                                <?php } ?>
                            </ul>
                        </div>
                    <?php } ?>
                    <?php if (isset($shopi_options['list_link_3_footer']) && !empty($shopi_options['list_link_3_footer'])) { ?>
                        <div class="flex-1">
                            <?php if (isset($shopi_options['title_list_link_3_footer']) && !empty($shopi_options['title_list_link_3_footer'])) { ?>
                                <span class="text-[13px] text-[#969fae] font-bold mb-11 flex a-md:mb-4 a-md:text-[#626264]">
                                    <?= @esc_attr($shopi_options['title_list_link_3_footer']) ?>
                                </span>
                            <?php } ?>
                            <ul class="flex flex-col gap-[19px] list-link-footer">
                                <?php
                                foreach ($shopi_options['list_link_3_footer']['redux_repeater_data'] as $key =>  $link) {
                                    $link = $shopi_options['list_link_3_footer'];
                                    $link_text   = isset($link['text'][$key]) ? $link['text'][$key] : '';
                                    $link_url    = isset($link['url'][$key]) && !empty($link['url'][$key]) ? $link['url'][$key] : '#';
                                    $link_target = isset($link['target'][$key]) ? $link['target'][$key] : '_self';
                                    $link_rel    = isset($link['rel'][$key]) ? $link['rel'][$key] : '';
                                    $link_flow   = isset($link['flow'][$key]) ? $link['flow'][$key] : '';
                                ?>
                                    <li>
                                        <a class="text-[13px] text-[#969fae] font-bold line-clamp-1" href="<?= esc_url($link_url); ?>" target="<?= esc_attr($link_target); ?>" rel="<?= esc_attr($link_rel); ?>" flow="<?= esc_attr($link_flow); ?>">
                                            <?= esc_html($link_text); ?>
                                        </a>
                                    </li>
                                <?php } ?>
                            </ul>
                        </div>
                    <?php } ?>
                </div>
                <div class="max-w-[406px] min-w-[406px] a-md:max-w-full a-md:min-w-full">
                    <span class="text-[13px] text-[#969fae] font-bold mb-12 line-clamp-1 a-md:mb-1 a-md:text-[#626264]">از
                        جدیدترین
                        تخفیف ها با
                        خبر شوید</span>
                    <div class="box-news-letter mb-6">
                        <span class="text-[14px] text-[#969fae] font-bold mb-3 flex">برای اطلاع از آخرین تخفیف‌ها و
                            جدیدترین
                            کالاها در
                            خبرنامه ثبت‌نام کنید.</span>
                        <div class="relative">
                            <form action="#mailchimp" method="post" id="mailchimp">
                                <input name="email" type="email" placeholder="آدرس ایمیل خود را وارد نمایید." required>
                                <button type="submit" name="mailchimp_submit">
                                    <svg class="icon w-[9px] h-[9px] fill-white">
                                        <use xlink:href="#arrow-left-wave-icon"></use>
                                    </svg>
                                </button>
                                <?= csrf_field() ?>
                            </form>
                            <?php if (isset($success) && !empty($success)) { ?>
                                <span class="text-[13px] text-green-500 font-bold absolute -bottom-6 left-0"><?= @esc_attr($success) ?></span>
                            <?php } ?>
                        </div>
                    </div>
                    <?php if (isset($shopi_options['list_social_footer']) && !empty($shopi_options['list_social_footer'])) { ?>
                        <div>
                            <?php if (isset($shopi_options['title_social_footer']) && !empty($shopi_options['title_social_footer'])) { ?>
                                <span class="text-[13px] text-[#969fae] font-bold mb-4 flex a-md:text-[#626264]">
                                    <?= @esc_attr($shopi_options['title_social_footer']) ?>
                                </span>
                            <?php } ?>
                            <ul class="list-social-footer flex items-center justify-end gap-8 a-md:flex-wrap">
                                <?php
                                foreach ($shopi_options['list_social_footer']['redux_repeater_data'] as $key =>  $link) {
                                    $item = $shopi_options['list_social_footer'];
                                    $title   = isset($item['title'][$key]) ? $item['title'][$key] : '';
                                    $link   = isset($item['link'][$key]) && !empty($item['link'][$key]) ? $item['link'][$key] : '#';
                                    $icon   = isset($item['icon'][$key]) ? $item['icon'][$key] : '';
                                ?>
                                    <li>
                                        <a href="<?= @$link ?>" title="<?= @esc_attr($title) ?>" class="<?= $key == 0 ? 'active' : '' ?>" target="_blank" rel="nofollow">
                                            <svg class="fill-[#969fae] w-[18px] h-[18px]">
                                                <use xlink:href="#<?= @esc_attr($icon) ?>">
                                                </use>
                                            </svg>
                                            <span><?= @esc_attr($title) ?></span>
                                        </a>
                                    </li>
                                <?php } ?>
                            </ul>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <?php if (!empty($shopi_options['nemad_footer']) && !empty($shopi_options['nemad_footer'])) { ?>
                <div class="bg-[#f8f9fb] rounded-[20px] tab:rounded-[8px] px-9 py-5 flex items-center gap-5 a-md:flex-col a-md:px-4">
                    <div class="flex items-center gap-4">
                        <svg class="w-4 h-4">
                            <use xlink:href="#permissions-icon">
                            </use>
                        </svg>
                        <span class="flex flex-col">
                            <?php if (isset($shopi_options['title_nemad_footer']) && !empty($shopi_options['title_nemad_footer'])) { ?>
                                <span class="text-[14px] text-[#969fae] font-bold"><?= @esc_attr($shopi_options['title_nemad_footer']) ?></span>
                            <?php } ?>
                            <?php if (isset($shopi_options['title_en_nemad_footer']) && !empty($shopi_options['title_en_nemad_footer'])) { ?>
                                <span class="text-[11px] text-[#abb1bc] font-bold"><?= @esc_attr($shopi_options['title_en_nemad_footer']) ?></span>
                            <?php } ?>
                        </span>
                    </div>
                    <div class="content-permissions grow flex-wrap justify-end gap-10 a-md:justify-center a-md:gap-4">
                        <?= @$shopi_options['nemad_footer'] ?>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
    <div class="flex flex-wrap items-center justify-between gap-4 tab:flex-col tab:items-start border-t border-[#f1f2f7] py-8 tab:py-4">
        <div class='text-[11px] text-[#969fae] font-bold flex items-center gap-5 tab:gap-3'>
            <?php if (isset($shopi_options['pic_copyright']) && !empty($shopi_options['pic_copyright'])) { ?>
                <?= @wp_get_attachment_image($shopi_options['pic_copyright']['id'], 'full') ?>
            <?php } ?>
            <div class="flex flex-col gap-2">
                <?php if (isset($shopi_options['title_copyright_1']) && !empty($shopi_options['title_copyright_1'])) { ?>
                    <span><?= @$shopi_options['title_copyright_1'] ?></span>
                <?php } ?>
                <?php if (isset($shopi_options['title_copyright_2']) && !empty($shopi_options['title_copyright_2'])) { ?>
                    <span><?= @$shopi_options['title_copyright_2'] ?></span>
                <?php } ?>
            </div>
        </div>
        <a href="#Body-top" class='text-[12px] text-[#708189] font-bold flex items-center gap-4 tab:mr-auto'>
            بزن بریم بالا
            <svg class='fill-[#969fae] w-[10px] h-[10px]'>
                <use xlink:href='#arrow-top-footer'>
            </svg>
        </a>
    </div>
</footer>