  <?php
    class Af_Header_Cart extends \Elementor\Widget_Base {
        public function get_name() {
            return 'header_cart';
        }

        public function get_title() {
            return __('سبد خرید', 'af-theme');
        }

        public function get_icon() {
            return 'eicon-cart';
        }

        public function get_categories() {
            return ['af-header'];
        }

        protected function register_controls() {
            $this->start_controls_section(
                'section_cart_settings',
                [
                    'label' => __('تنظیمات سبد خرید', 'af-theme'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            $this->add_control(
                'cart_text',
                [
                    'label' => __('متن سبد خرید', 'af-theme'),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __('سبد خرید', 'af-theme'),
                    'description' => __('متنی که به عنوان عنوان سبد خرید نمایش داده می‌شود.', 'af-theme'),
                ]
            );

            $this->add_control(
                'enable_product_count',
                [
                    'label' => __('نمایش تعداد محصولات', 'af-theme'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __('فعال', 'af-theme'),
                    'label_off' => __('غیرفعال', 'af-theme'),
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'description' => __('تعداد محصولات موجود در سبد خرید را نمایش دهید.', 'af-theme'),
                ]
            );

            $this->add_control(
                'enable_mini_cart',
                [
                    'label' => __('فعال‌سازی مینی کارت', 'af-theme'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __('فعال', 'af-theme'),
                    'label_off' => __('غیرفعال', 'af-theme'),
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'description' => __('مینی کارت را برای نمایش جزئیات سریع سبد خرید فعال کنید.', 'af-theme'),
                ]
            );

            $this->end_controls_section();
        }


        protected function render() {
            $settings = $this->get_settings_for_display();
            $cart_count = WC()->cart->get_cart_contents_count();
    ?>
          <div class="relative box-cart">
              <a href="<?= @wc_get_cart_url() ?>" class="text-[16px] text-[#232c38] font-bold border border-[#e3e7ed] flex items-center gap-[10px] rounded-[20px] p-3 pr-[22px] cursor-pointer button-open-mini-cart w-full h-full">
                  <svg class="fill-[#232c38] w-5 h-5">
                      <use xlink:href="#cart-icon">
                      </use>
                  </svg>
                  <?= esc_html($settings['cart_text']); ?>
                  <?php if ($settings['enable_product_count'] === 'yes') { ?>
                      <span class="count-items-cart text-[19px] text-[#ffffff] font-bold bg-primary_bg rounded-[15px] h-[31px] min-w-[31px] flex items-center justify-center mr-auto px-1">
                          <?= @$cart_count ?>
                      </span>
                  <?php } ?>
              </a>
              <?php if ($settings['enable_mini_cart'] === 'yes') {  ?>
                  <div class="pt-3 absolute right-0 bottom-4 translate-y-full z-[99] min-w-[373px] max-w-[373px] box-mini-cart opacity-0 invisible transition-3s">
                      <div class="border border-[#dfe4ed] rounded-[20px] bg-white append-mini-cart">
                          <?php get_template_part('woocommerce/cart/mini-cart') ?>
                      </div>
                  </div>
              <?php } ?>
          </div>
  <?php
        }
    }
    ?>