<?php
class Af_Header_Logo extends \Elementor\Widget_Base {
    public function get_name() {
        return 'header_logo';
    }

    public function get_title() {
        return __('لوگو', 'af-theme');
    }

    public function get_icon() {
        return 'eicon-image';
    }

    public function get_categories() {
        return ['af-header'];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_logo_settings',
            [
                'label' => __('تنظیمات لوگو', 'af-theme'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'logo_image',
            [
                'label' => __('تصویر لوگو', 'af-theme'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => '',
                ],
                'description' => __('لوگو را برای نمایش در این قسمت انتخاب کنید.', 'af-theme'),
            ]
        );

        $this->add_control(
            'logo_size',
            [
                'label' => __('عرض لوگو', 'af-theme'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 150,
                'min' => 50,
                'max' => 500,
                'step' => 1,
                'description' => __('عرض لوگو را وارد کنید.', 'af-theme'),
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $logo_attachment_id = $settings['logo_image']['id'];
        $logo_height = isset($settings['logo_size']) ? $settings['logo_size'] : 60;
?>
        <a href="<?= home_url() ?>" class="mr-auto">
            <?= wp_get_attachment_image($logo_attachment_id, 'full', false, [
                'class' => 'w-max',
                'style' => 'height: ' . esc_attr($logo_height) . 'px;',
            ]) ?>
        </a>
<?php
    }
}
?>