<?php
if (isset($_SESSION['mobile_send_code_login'])) {
    $key = "transient_login_" . $_SESSION['mobile_send_code_login'];
}
?>
<div class="min-h-[100dvh] flex flex-col items-center justify-center login-info">
    <div class="flex flex-col items-center max-w-[400px] min-w-[400px] py-4 tab:min-w-[100%] tab:px-0 min-h-[82dvh] ">
        <a href="<?= home_url() ?>" class='text-[13px] text-primary_text font-bold flex flex-col items-center justify-center gap-2 mb-8'>
            <svg class='fill-primary_fill w-[17px] h-[17px]'>
                <use xlink:href='#arrow-top-bold-icon'>
            </svg>
            بازگشت به صفحه اصلی</a>

        <?php get_template_part('template-parts/login/login-box') ?>
    </div>
    <div class="flex items-center justify-between mt-8 w-full a-md:flex-col a-md:gap-4">
        <p class='text-[12px] text-[#969fae] font-bold leading-[2]'>ورود شما به معنای پذیرش شرایط سایت و قوانین حریم‌خصوصی است</p>
        <?php if (isset($shopi_options['list_attr_login']['redux_repeater_data']) && !empty($shopi_options['list_attr_login']['redux_repeater_data'])) {  ?>
            <ul class="flex items-center gap-7 flex-wrap justify-between tab:gap-4">
                <?php
                foreach ($shopi_options['list_attr_login']['redux_repeater_data'] as $key => $item) {
                    $item = $shopi_options['list_attr_login'];
                ?>
                    <li class="flex items-center gap-2 m-auto">
                        <?= wp_get_attachment_image($item['pic'][$key]['id'], 'full', false, ['class' => 'w-5 h-5 object-contain']) ?>
                        <span class='text-[13px] text-[#8e9cad] font-bold'><?= @esc_attr($item['title'][$key]) ?></span>
                    </li>
                <?php } ?>
            </ul>
        <?php } ?>
    </div>
</div>