<?php
$mega_menu = (array)(array)get_menu_items_by_registered_slug("mega-menu");
$mega_menu = json_decode(json_encode($mega_menu), true);
$mega_menu_main = array_filter($mega_menu, function ($value) {
    return $value["menu_item_parent"] == 0;
});
?>
<?php if (!empty($mega_menu_main)) {
    $i = 1;
    $j = 1;   ?>
    <div class="absolute bottom-5 pt-4 z-[99] w-[97vw] max-w-[1500px] pl-[30px] translate-y-full box-mega-menu opacity-0 invisible transition-3s">
        <div class="flex items-stretch border border-[#f3f5f7] rounded-[15px] bg-white overflow-hidden">
            <ul class="min-w-[160px] max-w-[160px] bg-[#f6f8fb] menu-tab-list">
                <?php foreach ($mega_menu_main as $menu_item) {

                    if ($menu_item['type'] == 'custom') {
                        $url = $menu_item['url'];
                        $title = $menu_item['post_title'];
                    } elseif ($menu_item['type'] == 'taxonomy') {
                        $url = get_term_link((int)$menu_item['object_id'], $menu_item['object']);
                        $title = $menu_item['title'];
                    } elseif ($menu_item['type'] == 'post_type') {
                        $url = $menu_item['url'];
                        $title = $menu_item['title'];
                    } else {
                        $url = get_permalink((int)$menu_item['object_id']);
                        $title = $menu_item['post_title'];
                    }


                    $target = !empty($menu_item['target']) ? ' target="' . esc_attr($menu_item['target']) . '"' : '';
                    $attr_title = !empty($menu_item['attr_title']) ? ' title="' . esc_attr($menu_item['attr_title']) . '"' : '';
                    $classes = !empty($menu_item['classes']) && is_array($menu_item['classes']) ? ' class="text-[14px] text-[#192435] font-bold bg-[#f6f8fb] w-full line-clamp-1 py-[10px] text-center transition-3s' . esc_attr(implode(' ', $menu_item['classes'])) . '"' : 'text-[14px] text-[#192435] font-bold bg-[#f6f8fb] w-full line-clamp-1 py-[10px] text-center transition-3s';
                ?>
                    <li class="<?= $i == 1 ? 'active' : "" ?>"><a href="<?= esc_url($url) ?>" <?= $classes . $target . $attr_title  ?>>
                            <?= esc_html($title) ?>
                        </a></li>
                <?php $i++;
                } ?>
            </ul>
            <div class="grow px-10 pt-9 list-tabs-menu">
                <?php if (isset($mega_menu_main) && !empty($mega_menu_main)) {
                    foreach ($mega_menu_main as $key => $value) {
                        $id = $value["ID"];
                        $mega_menu_sub_1 = array_filter($mega_menu, function ($value) use ($id) {
                            return $value["menu_item_parent"] == $id;
                        });
                ?>
                        <?php if (isset($mega_menu_sub_1) && !empty($mega_menu_sub_1)) { ?>
                            <div class="item-tab-menu <?= $j == 1 ? 'active' : "" ?>">
                                <div>
                                    <ul class="max-h-[310px] flex flex-col flex-wrap list-menu-mega">
                                        <?php foreach ($mega_menu_sub_1 as $key => $item_sub_1) {
                                            $id = $item_sub_1["ID"];
                                            $mega_menu_sub_2 = array_filter($mega_menu, function ($value) use ($id) {
                                                return $value["menu_item_parent"] == $id;
                                            });


                                            if (
                                                $item_sub_1['type'] == 'custom'
                                            ) {
                                                $url = $item_sub_1['url'];
                                                $title = $item_sub_1['post_title'];
                                            } elseif ($item_sub_1['type'] == 'taxonomy') {
                                                $url = get_term_link((int)$item_sub_1['object_id'], $item_sub_1['object']);
                                                $title = $item_sub_1['title'];
                                            } elseif ($item_sub_1['type'] == 'post_type') {
                                                $url = $item_sub_1['url'];
                                                $title = $item_sub_1['title'];
                                            } else {
                                                $url = get_permalink((int)$item_sub_1['object_id']);
                                                $title = $item_sub_1['post_title'];
                                            }


                                            $target = !empty($item_sub_1['target']) ? ' target="' . esc_attr($item_sub_1['target']) . '"' : '';
                                            $attr_title = !empty($item_sub_1['attr_title']) ? ' title="' . esc_attr($item_sub_1['attr_title']) . '"' : '';
                                            $classes = !empty($item_sub_1['classes']) && is_array($item_sub_1['classes']) ? ' class="text-[13px] text-[#5d6a7e] font-bold py-[6px] line-clamp-1' . esc_attr(implode(' ', $item_sub_1['classes'])) . '"' : 'text-[13px] text-[#5d6a7e] font-bold py-[6px] line-clamp-1';
                                            $main_checked = get_post_meta($id, '_menu_item_main', true);
                                        ?>
                                            <li class="<?= $main_checked ? 'main' : '' ?>"><a href="<?= esc_url($url) ?>" <?= $classes . $target . $attr_title  ?>>
                                                    <?= esc_html($title) ?>
                                                </a></li>
                                        <?php
                                        } ?>
                                    </ul>
                                </div>
                            </div>
                        <?php } ?>
                    <?php
                        $j++;
                    } ?>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>