<?php
global $wp_query;
$user = wp_get_current_user();
$panel_url = wc_get_endpoint_url('wishlist');
$tab = [
    "product" => ["title" => "محصولات", "type" => 'product', 'link' => 'محصول'],
    "post" => ["title" => "مقالات", "type" => 'post', 'link' => 'مقاله'],
];
$status_select = esc_attr(get_status_tab("product", $tab));
$meta_fav = esc_attr($tab[$status_select]['type']);

$paged = isset($wp_query->query["comment"]) ? intval($wp_query->query["comment"]) : 1;


$list_user = get_user_meta(get_current_user_id(), "wp_list_fav_$meta_fav", true);
$list_user = json_decode($list_user);
$paged = $wp_query->query["wishlist"] ? intval($wp_query->query["wishlist"]) : 1;


$args = array(
    "post_type" => esc_attr($meta_fav),
    'paged' => $paged,
    'post__in' => empty($list_user) ? [0] : $list_user,
    'posts_per_page' => 8
);
$the_query = new WP_Query($args);

?>
<div class="border-b border-[#f2f4f7] flex items-center gap-12 a-md:gap-8 mb-9">
    <span class="text-[17px] text-[#768699] font-bold pb-6 tab:text-[15px] tab:pb-4">علاقه مندی ها</span>
    <?php if (isset($tab) && !empty($tab)) { ?>
        <ul class="flex items-center gap-10 tab:gap-4 list-tab-panel">
            <?php foreach ($tab as $key => $value) { ?>
                <li class="">
                    <a class="text-[14px] text-[#97a0ae] font-bold pb-6 flex a-md:text-[13px] tab:pb-4 <?= ($status_select == $key) ? "active" : "" ?>" href="<?= $panel_url ?>?status=<?= $key ?>"><?= $value["title"] ?></a>
                </li>
            <?php } ?>
        </ul>
    <?php } ?>
</div>
<?php if ($the_query->have_posts()) { ?>
    <ul class="grid <?= $meta_fav == 'product' ? 'grid-cols-4 a-lg:grid-cols-3 a-md:grid-cols-2 tab:grid-cols-1' : 'grid-cols-2 ml:grid-cols-1' ?> gap-[18px] mb-6 ">
        <?php while ($the_query->have_posts()) {
            $the_query->the_post(); ?>
            <?php if ($meta_fav == 'product') { ?>
                <div class="item-product item-product-fav item-parent border border-[#f2f4f7] bg-[#ffffff] rounded-[7px] px-5 py-7 pb-5 flex flex-col">
                    <a href="<?php the_permalink() ?>" class="w-full mb-8 a-md:mb-4 tab:mb-2">
                        <?php if (has_post_thumbnail()) {
                            echo get_the_post_thumbnail(get_the_ID(), 'full', ['class' => 'max-w-[150px] max-h-[140px] min-h-[140px] object-contain m-auto tab:max-w-[70%]']);
                        } else {
                            echo wc_placeholder_img('full', ['class' => 'max-w-[150px] max-h-[140px] min-h-[140px] object-contain m-auto']);
                        } ?>
                    </a>
                    <a href="<?php the_permalink() ?>" class='title text-[15px] text-[#394454] font-bold !line-clamp-2 tab:text-[13px] leading-[1.8] mb-6'>
                        <?php the_title() ?>
                    </a>
                    <div class="flex items-center justify-between mt-auto min-h-[50px]">
                        <span class="remove-item-panel favorites-event-post cursor-pointer" data-id="<?php the_ID() ?>">
                            <svg class='fill-[#ccd2df] w-[17px] h-[19px] delete-icon transition-3s'>
                                <use xlink:href='#delete-icon'>
                            </svg>
                        </span>
                        <?php woocommerce_template_loop_price() ?>
                    </div>
                </div>
            <?php } else { ?>
                <span class="item-parent item-product-fav border border-[#f2f4f7] rounded-[7px] px-[28px] py-6 flex items-center justify-between gap-5 mob:px-3">
                    <a href="<?php the_permalink() ?>" class='text-[16px] text-[#495666] font-bold line-clamp-1 a-md:text-[14px] mob:text-[13px]'>
                        <?php the_title() ?>
                    </a>
                    <span class="remove-item-panel favorites-event-post cursor-pointer" data-id="<?php the_ID() ?>">
                        <svg class='fill-[#ccd2df] w-[17px] h-[19px] delete-icon transition-3s'>
                            <use xlink:href='#delete-icon'>
                        </svg>
                    </span>
                </span>
            <?php } ?>
        <?php } ?>
    </ul>
    <div class="comment-pagination">
        <?php
        $args = array(
            'base' => esc_url($panel_url) . '%_%',
            'format' => '%#%',
            'total' => $the_query->max_num_pages,
            'current' => $paged,
            'show_all' => false,
            'end_size' => 3,
            'mid_size' => 3,
            'prev_next' => true,
            'add_args' => false,
            'type' => '',
            'prev_text' => is_rtl() ? '&rarr;' : '&larr;',
            'next_text' => is_rtl() ? '&larr;' : '&rarr;',
        );
        echo paginate_links($args);
        ?>
    </div>
<?php } else { ?>
    <div class="mt-6">
        <?php print_msg('هیچ آیتمی یافت نشد') ?>
    </div>
<?php } ?>