<?php
global $shopi_options;
if (isset($_COOKIE['recentSearches'])) {
    $cookieData = stripslashes($_COOKIE['recentSearches']);
    $recentSearches =  json_decode($cookieData, true);
}
$shop_page_url = get_permalink(wc_get_page_id('shop'));
?>
<div class="inner w-full border border-[#dfe4ed] bg-[#ffffff] rounded-[20px] a-lg:rounded-[0_0_20px_20px] a-lg:border-none">
    <div class="p-[6px] before-search">
        <div class="px-5 py-6 a-lg:py-3 a-lg:px-[9px] flex flex-col gap-4">
            <?php if (isset($shopi_options['list_link_search']) && !empty($shopi_options['list_link_search'])) { ?>
                <div class="">
                    <?php if (isset($shopi_options['title_box_search']) && !empty($shopi_options['title_box_search'])) { ?>
                        <span class="text-[13px] text-[#969fae] font-bold pb-2 inline-block">
                            <?= @esc_attr($shopi_options['title_box_search']) ?>
                        </span>
                    <?php } ?>
                    <div class="swiper swiper-slider-search py-[2px] px-[1px] pl-9 rounded-[8px]">
                        <div class="swiper-wrapper">
                            <?php foreach ($shopi_options['list_link_search']['redux_repeater_data'] as $key =>  $link) {
                                $link = $shopi_options['list_link_search'];
                                $link_text   = isset($link['text'][$key]) ? $link['text'][$key] : '';
                                $link_url    = isset($link['url'][$key]) && !empty($link['url'][$key]) ? $link['url'][$key] : '#';
                                $link_target = isset($link['target'][$key]) ? $link['target'][$key] : '_self';
                            ?>
                                <div class="swiper-slide w-max !overflow-visible">
                                    <a class="item text-[13px] text-[#576376] font-bold rounded-[8px] border border-[#dfe4ed] px-2 py-[5px] !inline-block" href="<?= esc_url($link_url); ?>" target="<?= esc_attr($link_target); ?>">
                                        <?= esc_html($link_text); ?>
                                    </a>
                                </div>
                            <?php
                            } ?>

                        </div>
                        <span class="swiper-button-next-vip w-[31px] h-[32px] rounded-[8px] border border-[#dfe4ed] bg-white flex items-center justify-center absolute left-0 top-[1px] z-[99]" tabindex="0" role="button" aria-label="Next slide" aria-controls="swiper-wrapper-674c58ea5232e94a" aria-disabled="false">
                            <svg class="fill-[#969fae] w-[5px] h-[9px]">
                                <use xlink:href="#arrow-left-wave-icon">
                                </use>
                            </svg></span>
                    </div>
                </div>
            <?php } ?>
            <?php if (isset($recentSearches) && !empty($recentSearches)) { ?>
                <div class="">
                    <span class="text-[13px] text-[#969fae] font-bold pb-2 inline-block">
                        آخرین جستجوهای شما
                    </span>
                    <div class="swiper swiper-slider-search py-[2px] px-[1px] pl-9 rounded-[8px] !overflow-visible">
                        <div class="swiper-wrapper">
                            <?php foreach ($recentSearches as $key => $value) { ?>
                                <div class="swiper-slide w-max">
                                    <a href="<?= $shop_page_url ?>?s=<?= esc_attr($value); ?>" class="item text-[13px] text-[#576376] font-bold rounded-[8px] border border-[#dfe4ed] px-2 py-[5px] !inline-block" href="<?= esc_url($link_url); ?>" target="<?= esc_attr($link_target); ?>">
                                        <?= esc_attr($value); ?>
                                    </a>
                                </div>
                            <?php
                            } ?>
                        </div>
                        <span class="swiper-button-next-vip w-[31px] h-[32px] rounded-[8px] border border-[#dfe4ed] bg-white flex items-center justify-center absolute left-0 top-[1px] z-[99]" tabindex="0" role="button" aria-label="Next slide" aria-controls="swiper-wrapper-674c58ea5232e94a" aria-disabled="false">
                            <svg class="fill-[#969fae] w-[5px] h-[9px]">
                                <use xlink:href="#arrow-left-wave-icon">
                                </use>
                            </svg></span>
                    </div>
                </div>
            <?php } ?>
        </div>
        <?php if (isset($shopi_options['banner_box_search']['id']) && !empty($shopi_options['banner_box_search']['id'])) { ?>
            <a class="text-[12px] text-[#969fae] font-bold" href="<?= @$shopi_options['link_banner_box_search'] ?? "#" ?>" target="<?= esc_attr($shopi_options['target_link_banner_box_search']); ?>" rel="<?= esc_attr($shopi_options['rel_link_banner_box_search']); ?>">
                <?= wp_get_attachment_image($shopi_options['banner_box_search']['id'], 'full', false, ['class' => 'w-full !rounded-[0_0_13px_13px]']) ?>
            </a>
        <?php } ?>
    </div>
    <div class="after-search py-10 px-6 overflow-hidden hidden a-lg:px-[15px] a-lg:py-5">

    </div>
</div>