<?php
$product = get_query_var('product');
$variation_id = get_query_var('variation_id');
if (!($product instanceof WC_Product)) {
    return;
}
if ($product->is_type('variable')) {
    $available_variations = $product->get_available_variations();
    if (!empty($available_variations)) {
        if ($variation_id) {
            $variation = wc_get_product($variation_id);
        } else {
            foreach ($available_variations as $variation_data) {
                $variation_product = wc_get_product($variation_data['variation_id']);
                if ($variation_product && $variation_product->is_in_stock() && $variation_product->get_price() > 0) {
                    $variation = $variation_product;
                    break;
                }
            }
        }
    }
} elseif ($product->is_type('simple')) {
    $variation = $product;
}


$variation_text = wc_get_formatted_variation($variation, true);
if (!empty($variation_text)) {
    $variation_text = str_replace("pa_", '', $variation_text);
    $variation_text = str_replace("-", ' ', $variation_text);
    $variation_list = explode(",", $variation_text);
}

?>
<?php if (isset($variation) && !empty($variation)) { ?>
    <div class="sidebar-shop-container">
        <div class="drop-shadow-action-sticky-pro rounded-[9px] bg-white px-2 py-8 pb-6 mb-8 a-md:mb-3 a-md:py-4">
            <div class="flex items-center gap-7 pb-5 mb-7 border-b border-[#eceff4] px-6 a-md:px-2 a-md:pb-4 a-md:mb-4">
                <?php if (has_post_thumbnail($product->get_id())) {
                    echo get_the_post_thumbnail($product->get_id(), 'full', ['class' => 'w-14 h-14 object-contain']);
                } else {
                    echo wc_placeholder_img('full', ['class' => 'w-14 h-14 object-contain']);
                } ?>

                <span class='text-[15px] text-[#495666] font-bold line-clamp-2 leading-[2]'><?= $product->get_name() ?></span>
            </div>
            <?php if (isset($variation_list) && !empty($variation_list)) { ?>
                <ul class="flex flex-col gap-4 pb-8 mb-7 border-b border-[#eceff4] px-6 a-md:mb-3 a-md:pb-4 a-md:gap-2 a-md:px-2">
                    <?php foreach ($variation_list as $key => $value) { ?>
                        <li class='text-[14px] text-[#495666] font-bold flex items-center gap-3'>
                            <?= $value ?>
                        </li>
                    <?php } ?>
                </ul>
            <?php } ?>
            <div class="px-6 flex flex-col gap-1 a-md:px-2 woocommerce-variation-price">
                <?= $variation->get_price_html(); ?>
            </div>
        </div>
        <?php if (is_product_available($product->get_id())) { ?>
            <?php wc_get_template('loop/add-to-cart.php', ['type' => 'side_single', 'product' => $variation]); ?>
        <?php } ?>
    </div>
<?php } ?>