<?php
/* template name: مقالات  */
$paged = get_query_var('paged') ? get_query_var('paged') : 1;
$search = get_query_var('search');
$current_tem = get_queried_object();
$title_main = $term->post_title ?? '';
$order_by = $_GET['order_by'] ?? 'new';

$args = array(
	'post_type' => 'post',
	'paged' => $paged,
	'post_status ' => 'publish',
	'meta_query' => ['relation' => 'AND']
);
if (isset($search) && !empty($search)) {
	$args["s"] = esc_attr($search);
	$title_main = "جست و جو شده برای : $search : ";
}
if (isset($current_tem->term_id) && !empty($current_tem->term_id)) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => $current_tem->taxonomy,
			'field' => 'term_id',
			'terms' => $current_tem->term_id,
		),
	);
	$title_main = $current_tem->cat_name;
}
if (isset($order_by) && !empty($order_by)) {
	if ($order_by == 'views') {
		$args['meta_key'] = 'views';
		$args['orderby'] = 'meta_value_num';
	}
	if ($order_by == 'comment_count') {
		$args['orderby'] = 'comment_count';
	}
}
$list_posts = new WP_Query($args);
$has_pagination = $list_posts->max_num_pages > 1;
?>
<?php get_header(); ?>
<main>
	<div class="container 2xl">
		<div class="flex items-center gap-16 mb-11 a-md:mb-6 a-lg:gap-3 a-lg:flex-wrap a-lg:justify-between tab:mb-3">
			<div class="breadcrumbs scrollbar-hide  flex items-center text-[13px] text-[#969fae] font-bold fill-[#cbd0da] grow a-lg:w-full">
				<nav class="woocommerce-breadcrumb" aria-label="Breadcrumb">
					<?= woocommerce_breadcrumb() ?>
				</nav>
			</div>
			<div class="tab-wrap flex items-center">
				<ul class="list-tab-archive-blog flex items-center gap-7 a-sm:gap-4">
					<li class="text-[13px] text-[#b1bcca] font-bold <?= isset($order_by) && $order_by == 'new' ? 'active' : ''  ?>">
						<a href="<?= add_query_arg('order_by', 'new') ?>" class="">جدیدترین ها</a>
					</li>
					<li class="text-[13px] text-[#b1bcca] font-bold <?= isset($order_by) && $order_by == 'views' ? 'active' : ''  ?>">
						<a href="<?= add_query_arg('order_by', 'views') ?>" class="">پربازدید ها</a>
					</li>
					<li class="text-[13px] text-[#b1bcca] font-bold <?= isset($order_by) && $order_by == 'comment_count' ? 'active' : ''  ?>">
						<a href="<?= add_query_arg('order_by', 'comment_count') ?>" class="">بیشترین کامنت</a>
					</li>
				</ul>
			</div>
			<form action="" class="flex items-center tab:w-full tab:border tab:border-[#eee] tab:rounded-[7px] tab:overflow-hidden">
				<input name="search" value="<?= @esc_attr($search) ?>" class="text-[13px] text-[#b1bcca] font-bold bg-transparent focus:outline-none max-w-[60px] hover:max-w-[100px] transition-3s tab:max-w-full tab:grow tab:p-3 tab:hover:max-w-full" type="text" placeholder="جستجو">
				<button type="submit" class="tab:p-3">
					<svg class="fill-[#b8c1d0] w-[14px] h-[14px]">
						<use xlink:href="#search-vip-icon">
						</use>
					</svg>
				</button>
			</form>
		</div>
		<div class="flex gap-8 a-xl:gap-3 ml:gap-0 ml:flex-col">
			<div class="max-w-[279px] min-w-[279px]">
				<div class="filter cursor-pointer fixed left-[15px] bottom-5 bg-[#f73148] rounded-[7px] w-10 h-10 hidden items-center justify-center shadow-[-3px_3px_6px_#0219591a] a-md:flex z-[99]" id="filter">
					<div class="button-filter flex flex-col items-center">
						<span class="icn inline-block">
							<svg width="25" height="25" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M1.5 2.64286C1.5 3.01057 1.5 4.70931 1.5 5.87377C1.5 6.57346 1.86565 7.22137 2.46419 7.58375L4.90316 9.06035C5.42264 9.37486 5.77109 9.90835 5.85028 10.5104L6.22751 13.3786C6.30587 13.9744 6.88821 14.367 7.46988 14.2162L9.26154 13.7518C9.67371 13.645 9.97303 13.2889 10.0074 12.8645L10.1925 10.5776C10.2443 9.93727 10.6006 9.3608 11.1501 9.02808L13.5358 7.58375C14.1344 7.22137 14.5 6.57329 14.5 5.8736C14.5 4.83391 14.5 3.34771 14.5 2.64286M1.5 2.64286C1.5 3.7888 5 4.5 8 4.5C11 4.5 14.5 3.21737 14.5 2.64286M1.5 2.64286C1.5 2.07143 3.86364 1 8 1C12.143 1 14.5 2.07143 14.5 2.64286" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
								</path>
								<path d="M7.9668 3.78571C3.85099 3.78572 1.5 3.78573 1.5 2.64286C1.5 2.07143 3.86364 1.5 8 1.5C12.143 1.5 14.5 2.07143 14.5 2.64286C14.5 3.21737 12.1364 3.78571 8 3.78571H7.9668Z" fill="#fff" stroke="#fff" stroke-width="1.75" stroke-linecap="round" stroke-linejoin="round">
								</path>
							</svg>
						</span>
					</div>
					<!-- .button-filter -->
				</div>
				<div id="sidebar-archive" class="sidebar-archive-blog top-2 sticky">
					<?php dynamic_sidebar('sidebar_blog'); ?>
				</div>
			</div>
			<div class="grow ml:w-full">
				<?php if ($list_posts->have_posts()) { ?>
					<div class="grid grid-cols-3 gap-x-8 gap-y-14 mb-11 a-sxl:gap-x-3 a-lg:grid-cols-2 ml:gap-y-5 tab:grid-cols-1">
						<?php while ($list_posts->have_posts()) {
							$list_posts->the_post(); ?>
							<?php get_template_part('template-parts/cards/card', 'post') ?>
						<?php } ?>
					</div>
				<?php } else { ?>
					<?= print_msg('هیچ مقاله ای پیدا نشد') ?>
				<?php } ?>
				<?php if ($has_pagination) { ?>
					<?= custom_pagination($list_posts) ?>
				<?php } ?>
			</div>
		</div>
	</div>
</main>
<?php get_footer() ?>