<?php

/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.9.0
 */

defined('ABSPATH') || exit;
global $shopi_options;
$sidebar_position = isset($shopi_options['cart_checkout_sidebar_position']) ? $shopi_options['cart_checkout_sidebar_position'] : 'left';
$sidebar_class = ($sidebar_position === 'right') ? 'order-1' : 'order-2';
?>
<?php do_action('woocommerce_before_cart'); ?>

<form class="woocommerce-cart-form flex gap-7 mb-9 a-sxl:gap-3 a-lg:flex-col-reverse" action="<?php echo esc_url(wc_get_cart_url()); ?>" method="post">
	<div class="grow order-2 border border-[#e7ebf2] rounded-[7px] px-8 py-6 mb-4 a-md:p-4">
		<div class="border-b border-[#e8ecf3] flex items-center gap-2 pb-5 mb-10 a-md:mb-5 a-sm:pb-1">
			<span class="text-[21px] text-[#394454] font-bold"><?= WC()->cart->get_cart_contents_count() ?></span>
			<span class="text-[14px] text-[#969fae] font-bold">محصول در سبد خرید</span>
		</div>
		<?php do_action('woocommerce_before_cart_table'); ?>
		<ul>
			<?php do_action('woocommerce_before_cart_contents'); ?>

			<?php
			foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
				$_product   = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
				$product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);
				/**
				 * Filter the product name.
				 *
				 * @since 2.1.0
				 * @param string $product_name Name of the product in the cart.
				 * @param array $cart_item The product in the cart.
				 * @param string $cart_item_key Key for the product in the cart.
				 */
				$product_name = apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key);

				if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_cart_item_visible', true, $cart_item, $cart_item_key)) {
					$product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
					$discount = get_product_discount_percentage($_product->get_id());
					$discount_days = get_discount_days_remaining($_product->get_id());
			?>
					<li class="woocommerce-cart-form__cart-item <?php echo esc_attr(apply_filters('woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key)); ?>   relative flex items-stretch gap-7 pb-9 mb-9 border-b border-[#e8ecf3] last:pb-0 last:mb-0 last:border-none a-md:mb-4 a-md:pb-4 a-sm:flex-wrap a-sm:gap-3">
						<?php
						echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
							'woocommerce_cart_item_remove_link',
							sprintf(
								'<a href="%s" class="remove remove_from_cart_button absolute -top-3 w-4 h-4 bg-red-600 rounded-full flex items-center justify-center text-white" aria-label="%s" data-product_id="%s" data-product_sku="%s">&times;</a>',
								esc_url(wc_get_cart_remove_url($cart_item_key)),
								esc_html__('Remove this item', 'woocommerce'),
								esc_attr($product_id),
								esc_attr($_product->get_sku())
							),
							$cart_item_key
						);
						?>
						<?php
						$thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);
						$thumbnail = preg_replace('/class="([^"]*)"/i', 'class="$1 h-[86px] w-[120px] object-contain a-sm:h-[60px] a-sm:w-[80px]"', $thumbnail);

						if (!$product_permalink) {
							echo $thumbnail; // PHPCS: XSS ok.
						} else {
							printf('<a href="%s">%s</a>', esc_url($product_permalink), $thumbnail); // PHPCS: XSS ok.
						}
						?>
						<div class="flex flex-col gap-5 a-sm:gap-2">
							<?php
							if (!$product_permalink) {
								echo wp_kses_post($product_name . '&nbsp;');
							} else {
								/**
								 * This filter is documented above.
								 *
								 * @since 2.1.0
								 */
								echo wp_kses_post(apply_filters('woocommerce_cart_item_name', sprintf('<a class="text-[17px] text-[#394454] font-bold a-md:text-[15px] line-clamp-1" href="%s">%s</a>', esc_url($product_permalink), $_product->get_name()), $cart_item, $cart_item_key));
							}

							do_action('woocommerce_after_cart_item_name', $cart_item, $cart_item_key);

							// Meta data.
							echo wc_get_formatted_cart_item_data($cart_item); // PHPCS: XSS ok.

							// Backorder notification.
							if ($_product->backorders_require_notification() && $_product->is_on_backorder($cart_item['quantity'])) {
								echo wp_kses_post(apply_filters('woocommerce_cart_item_backorder_notification', '<p class="backorder_notification">' . esc_html__('Available on backorder', 'woocommerce') . '</p>', $product_id));
							}
							?>
						</div>
						<div class="flex flex-col items-end gap-2 mr-auto a-sm:w-full a-sm:flex-row a-sm:justify-between a-sm:items-center">
							<div class="product-quantity flex items-stretch gap-3 a-sm:gap-[2px]">
								<span class="plus w-[31px] h-[31px] border border-[#e7ebf2] rounded-[5px] flex items-center justify-center cursor-pointer">
									<svg class="fill-secondary_fill w-[12px] h-[12px]">
										<use xlink:href="#plus-icon">
										</use>
									</svg>
								</span>
								<?php
								if ($_product->is_sold_individually()) {
									$min_quantity = 1;
									$max_quantity = 1;
								} else {
									$min_quantity = 0;
									$max_quantity = $_product->get_max_purchase_quantity();
								}

								$product_quantity = woocommerce_quantity_input(
									array(
										'input_name'   => "cart[{$cart_item_key}][qty]",
										'input_value'  => $cart_item['quantity'],
										'max_value'    => $max_quantity,
										'min_value'    => $min_quantity,
										'product_name' => $product_name,
										'classes' => 'input-text qty text-[15px] text-[#28313b] font-bold border-b border-t border-[#e7ebf2] focus:outline-none max-w-[27px] text-center a-sm:border a-sm:max-w-[55px] a-sm:rounded-[5px]'
									),
									$_product,
									false
								);

								echo apply_filters('woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item); // PHPCS: XSS ok.
								?>
								<span class="minus w-[31px] h-[31px] border border-[#e7ebf2] rounded-[5px] flex items-center justify-center cursor-pointer">
									<svg class="fill-[#b2bcc9] w-[8px] h-[2px]">
										<use xlink:href="#minus-icon">
										</use>
									</svg>
								</span>
							</div>
							<div class="flex items-center gap-5">
								<?php if (isset($discount_days) && !empty($discount_days)) { ?>
									<span class="text-[13px] text-[#677381] font-bold a-md:text-[12px] a-sm:hidden">
										<ins class="text-[17px] text-primary_text font-bold mx-2 a-md:text-[15px]"><?= @$discount_days ?></ins>روز
										تا پایان
										تخفیف </span>
								<?php } ?>
								<?php if (isset($discount) && !empty($discount)) { ?>
									<span class="inline-flex items-center gap-1 text-[19px] text-[#ffffff] font-bold h-[24px] rounded-[20px_20px_20px_0] bg-primary_bg p-[2px_9px_0_9px] leading-[1] a-md:text-[15px] a-sm:absolute a-sm:top-0 a-sm:left-0">
										<?= @$discount ?>
										<svg class="fill-[#fcfcfc] w-[11px] h-[11px] a-md:w-2 a-md:h-2">
											<use xlink:href="#discount-icon">
											</use>
										</svg>
									</span>
								<?php } ?>
								<div class="product-price text-[37px] text-[#28313b] font-bold flex items-center -ml-1 a-md:text-[28px]">
									<?php
									echo apply_filters('woocommerce_cart_item_price', WC()->cart->get_product_price($_product), $cart_item, $cart_item_key); // PHPCS: XSS ok.
									?>
								</div>
							</div>
						</div>
					</li>
			<?php
				}
			}
			?>
			<?php do_action('woocommerce_cart_contents'); ?>
		</ul>
		<table>
			<tr class="hidden">
				<td colspan="6" class="actions">

					<?php if (wc_coupons_enabled()) { ?>
						<div class="coupon ">
							<label for="coupon_code" class="screen-reader-text"><?php esc_html_e('Coupon:', 'woocommerce'); ?></label> <input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="<?php esc_attr_e('Coupon code', 'woocommerce'); ?>" /> <button type="submit" class="button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="apply_coupon" value="<?php esc_attr_e('Apply coupon', 'woocommerce'); ?>"><?php esc_html_e('Apply coupon', 'woocommerce'); ?></button>
							<?php do_action('woocommerce_cart_coupon'); ?>
						</div>
					<?php } ?>

					<button type="submit" class="hidden button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="update_cart" value="<?php esc_attr_e('Update cart', 'woocommerce'); ?>"><?php esc_html_e('Update cart', 'woocommerce'); ?></button>

					<?php do_action('woocommerce_cart_actions'); ?>

					<?php wp_nonce_field('woocommerce-cart', 'woocommerce-cart-nonce'); ?>
				</td>
			</tr>
		</table>
		<?php do_action('woocommerce_after_cart_table'); ?>
	</div>

	<?php do_action('woocommerce_before_cart_collaterals'); ?>

	<div class="cart-collaterals max-w-[331px] min-w-[331px] a-lg:max-w-full a-lg:min-w-full <?php echo esc_attr($sidebar_class); ?>">
		<?php
		/**
		 * Cart collaterals hook.
		 *
		 * @hooked woocommerce_cross_sell_display
		 * @hooked woocommerce_cart_totals - 10
		 */
		remove_action("woocommerce_cart_collaterals", "woocommerce_cross_sell_display" , 10);
		do_action('woocommerce_cart_collaterals');
?>
	</div>
	</div>
</form>
<?php do_action('woocommerce_after_cart'); ?>
<div>
	<?php woocommerce_cross_sell_display() ?>
</div>