<?php

/**
 * Checkout login form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.8.0
 */

defined('ABSPATH') || exit;

if (is_user_logged_in() || 'no' === get_option('woocommerce_enable_checkout_login_reminder')) {
	return;
}
global $shopi_options;
?>
<?php if ($shopi_options['enable_checkout_login_popup'] != '1') { ?>
	<div class="woocommerce-form-login-toggle max-w-[500px] m-auto">
		<?php wc_print_notice(apply_filters('woocommerce_checkout_login_message', esc_html__('Returning customer?', 'woocommerce')) . ' <a href="#" class="showlogin">' . esc_html__('Click here to login', 'woocommerce') . '</a>', 'notice'); ?>
	</div>
	<?php
	woocommerce_login_form(
		array(
			'message'  => esc_html__('If you have shopped with us before, please enter your details below. If you are a new customer, please proceed to the Billing section.', 'woocommerce'),
			'redirect' => wc_get_checkout_url(),
			'hidden'   => true,
		)
	);
	?>
<?php } else {  ?>
	<div class="p-6 py-5 flex items-center justify-between gap-3 bg-[#f8f9fb] rounded-[10px] mb-6 tab:flex-col">
		<span class='text-[18px] text-[#495666] font-bold a-md:text-[15px]'>جهت ثبت سفارش، حتما باید وارد حساب کاربری خود شوید</span>
		<span class='open-login-checkout text-[16px] text-[#fff] font-bold bg-primary_bg px-10 py-4 rounded-[7px] flex items-center gap-3 cursor-pointer a-md:text-[14px] a-md:px-5 a-md:py-3'>
			<svg class='fill-white w-5 h-5'>
				<use xlink:href='#user-icon'>
			</svg>
			ورود و ثبت نام
		</span>
	</div>
	<div class="box-poupup box-poupup-login">
		<?php get_template_part('template-parts/login/login-box') ?>
	</div>
<?php } ?>