<?php

/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.1.0
 *
 * @var WC_Order $order
 */

defined('ABSPATH') || exit;
?>
<svg width="0" height="0" class="hidden">
	<symbol viewBox="0 0 144 145" id="cart-tanks-icon">
		<path fill-rule="evenodd" clip-rule="evenodd" d="M51 81.1699C53.8995 81.1699 56.25 83.5204 56.25 86.4199C56.25 95.0404 63.3795 102.17 72 102.17C80.6205 102.17 87.75 95.0404 87.75 86.4199C87.75 83.5204 90.1005 81.1699 93 81.1699C95.8995 81.1699 98.25 83.5204 98.25 86.4199C98.25 100.839 86.4195 112.67 72 112.67C57.5805 112.67 45.75 100.839 45.75 86.4199C45.75 83.5204 48.1005 81.1699 51 81.1699Z" fill="#00A651"></path>
		<g filter="url(#filter0_d_1_40)">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M56.5672 9.20249C58.6203 11.2499 58.6249 14.574 56.5774 16.6271L34.8574 38.4071C32.81 40.4602 29.4859 40.4648 27.4328 38.4174C25.3797 36.3699 25.3752 33.0458 27.4226 30.9927L49.1426 9.21274C51.19 7.15966 54.5141 7.15507 56.5672 9.20249Z" fill="#E4E8F1"></path>
		</g>
		<g filter="url(#filter1_d_1_40)">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M87.4328 9.20249C89.4859 7.15507 92.81 7.15966 94.8574 9.21274L116.577 30.9927C118.625 33.0458 118.62 36.3699 116.567 38.4174C114.514 40.4648 111.19 40.4602 109.143 38.4071L87.4226 16.6271C85.3752 14.574 85.3797 11.2499 87.4328 9.20249Z" fill="#E4E8F1"></path>
		</g>
		<g filter="url(#filter2_d_1_40)">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M18.8141 42.2195C18.4713 42.4491 17.25 43.3318 17.25 48.02C17.25 50.9115 17.5929 52.5504 17.9369 53.4355C18.2114 54.142 18.4371 54.2664 18.5052 54.304C18.5085 54.3058 18.5115 54.3074 18.514 54.3089C18.7222 54.4289 19.2425 54.6301 20.5101 54.7232C21.4799 54.7945 22.4708 54.787 23.739 54.7775C24.2212 54.7739 24.7435 54.77 25.32 54.77H118.68C119.256 54.77 119.779 54.7739 120.261 54.7775C121.529 54.787 122.52 54.7945 123.49 54.7232C124.758 54.6301 125.278 54.4289 125.486 54.3089C125.489 54.3074 125.491 54.3058 125.495 54.304C125.563 54.2664 125.789 54.142 126.063 53.4355C126.407 52.5504 126.75 50.9115 126.75 48.02C126.75 43.3318 125.529 42.4491 125.186 42.2195C124.278 41.6116 122.531 41.27 118.68 41.27H25.32C21.4688 41.27 19.7217 41.6116 18.8141 42.2195ZM12.9709 33.4955C16.8783 30.8785 21.7912 30.77 25.32 30.77H118.68C122.209 30.77 127.122 30.8785 131.029 33.4955C135.501 36.4909 137.25 41.6083 137.25 48.02C137.25 54.9482 135.69 60.5468 130.729 63.4062C128.53 64.6737 126.181 65.0537 124.259 65.195C122.826 65.3003 121.224 65.2875 119.833 65.2764C119.428 65.2731 119.04 65.27 118.68 65.27H25.32C24.9598 65.27 24.5725 65.2731 24.1674 65.2764C22.7757 65.2875 21.1741 65.3003 19.7405 65.195C17.8187 65.0537 15.4703 64.6737 13.271 63.4062C8.30957 60.5468 6.75 54.9482 6.75 48.02C6.75 41.6083 8.49873 36.4909 12.9709 33.4955Z" fill="#E4E8F1"></path>
		</g>
		<g filter="url(#filter3_d_1_40)">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M123.989 55.7639C126.836 56.31 128.702 59.0611 128.156 61.9087L118.076 114.467C118.076 114.468 118.076 114.468 118.076 114.469C117.018 119.994 115.605 126.35 111.115 131.055C106.4 135.995 99.3283 138.17 89.34 138.17H53.16C43.7272 138.17 36.7152 135.811 31.8593 130.894C27.1515 126.126 25.2913 119.745 24.28 113.614L15.8185 61.7655C15.3515 58.9039 17.2928 56.2055 20.1544 55.7385C23.0161 55.2715 25.7145 57.2127 26.1815 60.0743L34.64 111.905C34.6402 111.907 34.6404 111.908 34.6407 111.91C35.5494 117.417 36.9591 121.114 39.3307 123.516C41.5548 125.768 45.4328 127.67 53.16 127.67H89.34C98.0117 127.67 101.65 125.765 103.52 123.805C105.614 121.61 106.662 118.247 107.764 112.493L107.764 112.491L117.844 59.9311C118.39 57.0835 121.141 55.2178 123.989 55.7639Z" fill="#E4E8F1"></path>
		</g>
		<defs>
			<filter id="filter0_d_1_40" x="25.89" y="7.66992" width="33.22" height="33.28" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
				<feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood>
				<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"></feColorMatrix>
				<feOffset dx="1" dy="1"></feOffset>
				<feComposite in2="hardAlpha" operator="out"></feComposite>
				<feColorMatrix type="matrix" values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0"></feColorMatrix>
				<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_1_40"></feBlend>
				<feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_1_40" result="shape"></feBlend>
			</filter>
			<filter id="filter1_d_1_40" x="85.89" y="7.66992" width="33.22" height="33.28" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
				<feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood>
				<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"></feColorMatrix>
				<feOffset dx="1" dy="1"></feOffset>
				<feComposite in2="hardAlpha" operator="out"></feComposite>
				<feColorMatrix type="matrix" values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0"></feColorMatrix>
				<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_1_40"></feBlend>
				<feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_1_40" result="shape"></feBlend>
			</filter>
			<filter id="filter2_d_1_40" x="6.75" y="30.77" width="131.5" height="35.5137" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
				<feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood>
				<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"></feColorMatrix>
				<feOffset dx="1" dy="1"></feOffset>
				<feComposite in2="hardAlpha" operator="out"></feComposite>
				<feColorMatrix type="matrix" values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0"></feColorMatrix>
				<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_1_40"></feBlend>
				<feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_1_40" result="shape"></feBlend>
			</filter>
			<filter id="filter3_d_1_40" x="15.7492" y="55.6689" width="113.502" height="83.501" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
				<feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood>
				<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"></feColorMatrix>
				<feOffset dx="1" dy="1"></feOffset>
				<feComposite in2="hardAlpha" operator="out"></feComposite>
				<feColorMatrix type="matrix" values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0"></feColorMatrix>
				<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_1_40"></feBlend>
				<feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_1_40" result="shape"></feBlend>
			</filter>
		</defs>
	</symbol>
	<symbol viewBox="0 0 22 22" id="receipt-icon">
		<path d="M18.2693 6.66V15.34C18.2693 16.67 18.1468 17.615 17.8318 18.2887C17.8318 18.2975 17.823 18.315 17.8143 18.3238C17.6218 18.5688 17.368 18.6912 17.0705 18.6912C16.6068 18.6912 16.0468 18.385 15.4431 17.7375C14.7256 16.9675 13.623 17.0287 12.993 17.8687L12.1093 19.0412C11.7593 19.5137 11.2955 19.75 10.8318 19.75C10.368 19.75 9.90427 19.5137 9.55427 19.0412L8.6618 17.86C8.04055 17.0287 6.94678 16.9675 6.22928 17.7287L6.22052 17.7375C5.23177 18.7962 4.3568 18.9538 3.8493 18.3238C3.84055 18.315 3.83179 18.2975 3.83179 18.2887C3.51679 17.615 3.39429 16.67 3.39429 15.34V6.66C3.39429 5.33 3.51679 4.385 3.83179 3.71125C3.83179 3.7025 3.8318 3.69375 3.8493 3.685C4.34805 3.04625 5.23177 3.20375 6.22052 4.2625L6.22928 4.27125C6.94678 5.0325 8.04055 4.97125 8.6618 4.14L9.55427 2.95875C9.90427 2.48625 10.368 2.25 10.8318 2.25C11.2955 2.25 11.7593 2.48625 12.1093 2.95875L12.993 4.13125C13.623 4.97125 14.7256 5.0325 15.4431 4.2625C16.0468 3.615 16.6068 3.30875 17.0705 3.30875C17.368 3.30875 17.6218 3.44 17.8143 3.685C17.8318 3.69375 17.8318 3.7025 17.8318 3.71125C18.1468 4.385 18.2693 5.33 18.2693 6.66Z" stroke="#292D32" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
		<path d="M7.76929 9.46875H14.7693" stroke="#292D32" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
		<path d="M7.76929 12.5312H13.0193" stroke="#292D32" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
	</symbol>
	<symbol viewBox="0 0 20 20" id="wallet-icon">
		<path fill-rule="evenodd" clip-rule="evenodd" d="M6.79065 13.1882C6.79065 12.774 7.12644 12.4382 7.54065 12.4382H11.9156C12.3299 12.4382 12.6656 12.774 12.6656 13.1882C12.6656 13.6024 12.3299 13.9382 11.9156 13.9382H7.54065C7.12644 13.9382 6.79065 13.6024 6.79065 13.1882Z" fill="#292D32"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M7.75015 1.83735C7.22259 2.07529 6.70849 2.66534 6.1538 3.94833C6.1454 3.96776 6.13618 3.98682 6.12618 4.00546L6.12148 4.01918L6.11565 4.03662C6.10848 4.05813 6.10034 4.0793 6.09125 4.10007L6.0348 4.2291L5.99979 4.31663L5.03938 6.61039C5.17706 6.59901 5.31623 6.5932 5.45663 6.5932H7.4569L9.50238 1.84628C8.6907 1.62341 8.15304 1.65563 7.75015 1.83735ZM7.13343 0.469994C8.20443 -0.0130655 9.42058 0.171854 10.7821 0.692708C10.9727 0.765616 11.1253 0.91303 11.2049 1.10095C11.2844 1.28888 11.2839 1.50108 11.2035 1.68864L11.1767 1.75125L8.63916 7.64C8.52064 7.91503 8.24987 8.0932 7.95038 8.0932H5.45663C4.96519 8.0932 4.49575 8.19429 4.06925 8.37502C3.78844 8.494 3.46356 8.4311 3.24745 8.21592C3.03134 8.00074 2.96704 7.67613 3.08482 7.39481L4.61375 3.74285L4.64653 3.66091C4.64949 3.6535 4.65257 3.64614 4.65577 3.63884L4.70298 3.53091C4.71844 3.48496 4.7473 3.40475 4.79083 3.32112C5.37957 1.96866 6.08331 0.943636 7.13343 0.469994Z" fill="#292D32"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M9.82483 1.09778C9.97849 0.739247 10.3813 0.558351 10.7514 0.681701C10.8643 0.719337 11.0279 0.789996 11.1184 0.829075C11.1464 0.841158 11.1674 0.850221 11.1777 0.854356L11.1901 0.859319L13.122 1.67242C14.2302 2.13206 15.1216 2.65316 15.6958 3.35787C15.7965 3.47894 15.8934 3.609 15.9815 3.76782C16.0722 3.91204 16.1594 4.07983 16.2184 4.27376C16.2568 4.3667 16.2874 4.45902 16.3104 4.54625C16.6176 5.52886 16.3982 6.62722 15.9261 7.79862C15.78 8.16082 15.3805 8.35037 15.0076 8.23436C14.699 8.13834 14.3561 8.09321 13.9967 8.09321H7.95044C7.69807 8.09321 7.46262 7.96629 7.3239 7.75547C7.18519 7.54464 7.1618 7.27818 7.26167 7.04642L9.79917 1.15767L9.82483 1.09778ZM10.9105 2.36916L9.09029 6.59321H13.9967C14.2447 6.59321 14.497 6.60915 14.749 6.64504C14.9847 5.89501 14.9995 5.36962 14.8752 4.98272C14.8701 4.96701 14.8656 4.95113 14.8616 4.93512C14.8543 4.90588 14.842 4.86828 14.8251 4.83032C14.8091 4.79429 14.7959 4.75706 14.7858 4.71896C14.7771 4.68657 14.7569 4.63643 14.7046 4.55503C14.6941 4.53875 14.6843 4.52208 14.6751 4.50504C14.6454 4.44989 14.6083 4.39597 14.5405 4.3146L14.5346 4.30744C14.199 3.8944 13.5873 3.48915 12.5457 3.05727L12.542 3.05576L10.9105 2.36916Z" fill="#292D32"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M4.07961 8.3753C2.82349 8.91865 1.9469 10.1674 1.9469 11.6135V13.3198C1.9469 13.4892 1.96109 13.6657 1.98435 13.844C1.98641 13.8598 1.98797 13.8757 1.98902 13.8916C2.07288 15.1615 2.44627 16.035 3.02332 16.6121C3.60038 17.1891 4.47386 17.5625 5.74382 17.6464C5.75973 17.6474 5.7756 17.649 5.7914 17.6511C5.96971 17.6743 6.14622 17.6885 6.31565 17.6885H13.1406C14.6495 17.6885 15.6787 17.3295 16.3457 16.7293C17.0059 16.1352 17.4254 15.2017 17.5017 13.8053C17.5106 13.628 17.5182 13.4723 17.5182 13.3198V11.6135C17.5182 10.0221 16.4599 8.67842 15.0245 8.2367C14.7111 8.14451 14.3641 8.09351 14.0069 8.09351H5.4669C4.97926 8.09351 4.51839 8.19306 4.07961 8.3753ZM3.49844 6.99245C4.10838 6.73831 4.76611 6.59351 5.4669 6.59351H14.0069C14.5058 6.59351 14.9975 6.66461 15.4532 6.79924L15.4605 6.8014L15.4605 6.80144C17.5057 7.42837 19.0182 9.33876 19.0182 11.6135V13.3198C19.0182 13.5136 19.0086 13.7044 19.0001 13.8742L18.9997 13.8822L18.9995 13.8855C18.9094 15.5422 18.3927 16.9051 17.3491 17.8443C16.312 18.7775 14.8693 19.1885 13.1406 19.1885H6.31565C6.07395 19.1885 5.83883 19.1691 5.62127 19.1415C4.11925 19.0384 2.86617 18.5763 1.96266 17.6727C1.05915 16.7692 0.59701 15.5162 0.493876 14.0141C0.46626 13.7966 0.446899 13.5615 0.446899 13.3198V11.6135C0.446899 9.54367 1.70337 7.76612 3.49003 6.99601L3.49842 6.9924L3.49844 6.99245Z" fill="#292D32"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M5.88898 3.55271C6.06411 3.76733 6.10669 4.061 5.99971 4.31651L4.46846 7.97401C4.39346 8.15317 4.25188 8.29624 4.07352 8.37312C2.81517 8.91551 1.93665 10.1655 1.93665 11.6131C1.93665 12.0273 1.60086 12.3631 1.18665 12.3631C0.772432 12.3631 0.436646 12.0273 0.436646 11.6131V9.04938C0.436646 6.2002 2.46339 3.8229 5.16291 3.29102C5.43469 3.23748 5.71386 3.33809 5.88898 3.55271ZM2.09229 7.88834C2.4234 7.58862 2.79445 7.33233 3.1963 7.12847L3.92764 5.38164C3.04192 5.95691 2.3787 6.84471 2.09229 7.88834Z" fill="#292D32"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M14.9997 3.99145C15.2307 3.7634 15.5822 3.70983 15.8706 3.8587C17.7422 4.82464 19.0154 6.80233 19.0154 9.04892V11.6127C19.0154 12.0269 18.6796 12.3627 18.2654 12.3627C17.8512 12.3627 17.5154 12.0269 17.5154 11.6127C17.5154 10.0255 16.4615 8.67652 15.0224 8.24478C14.8208 8.1843 14.6538 8.04185 14.5624 7.85225C14.4709 7.66264 14.4634 7.44333 14.5416 7.24787C14.973 6.16923 15.0343 5.46881 14.8859 4.96429C14.8811 4.94813 14.8769 4.93181 14.8733 4.91536C14.8666 4.88532 14.8587 4.86637 14.8558 4.86058C14.7107 4.57025 14.7688 4.21949 14.9997 3.99145ZM17.3574 7.88294C17.1765 7.22958 16.8477 6.63654 16.41 6.14573C16.3648 6.45337 16.2893 6.76952 16.1883 7.09439C16.6154 7.30146 17.0086 7.56792 17.3574 7.88294Z" fill="#292D32"></path>
	</symbol>
	<symbol viewBox="0 0 19 18" id="total-icon">
		<path fill-rule="evenodd" clip-rule="evenodd" d="M2.46346 3.12088C1.89288 3.65071 1.5 4.51893 1.5 5.90723V12.0322C1.5 13.4205 1.89288 14.2887 2.46346 14.8186C3.0441 15.3577 3.92747 15.6572 5.125 15.6572H13.875C15.0725 15.6572 15.9559 15.3577 16.5365 14.8186C17.1071 14.2887 17.5 13.4205 17.5 12.0322V5.90723C17.5 4.51893 17.1071 3.65071 16.5365 3.12088C15.9559 2.58172 15.0725 2.28223 13.875 2.28223H5.125C3.92747 2.28223 3.0441 2.58172 2.46346 3.12088ZM1.44279 2.02169C2.3934 1.13899 3.69753 0.782227 5.125 0.782227H13.875C15.3025 0.782227 16.6066 1.13899 17.5572 2.02169C18.5179 2.91375 19 4.23303 19 5.90723V12.0322C19 13.7064 18.5179 15.0257 17.5572 15.9178C16.6066 16.8005 15.3025 17.1572 13.875 17.1572H5.125C3.69753 17.1572 2.3934 16.8005 1.44279 15.9178C0.482115 15.0257 0 13.7064 0 12.0322V5.90723C0 4.23303 0.482115 2.91375 1.44279 2.02169Z" fill="#292D32"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M9.5 7.09473C8.46447 7.09473 7.625 7.93419 7.625 8.96973C7.625 10.0053 8.46447 10.8447 9.5 10.8447C10.5355 10.8447 11.375 10.0053 11.375 8.96973C11.375 7.93419 10.5355 7.09473 9.5 7.09473ZM6.125 8.96973C6.125 7.10577 7.63604 5.59473 9.5 5.59473C11.364 5.59473 12.875 7.10577 12.875 8.96973C12.875 10.8337 11.364 12.3447 9.5 12.3447C7.63604 12.3447 6.125 10.8337 6.125 8.96973Z" fill="#292D32"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M3.8125 6.03223C4.22671 6.03223 4.5625 6.36801 4.5625 6.78223V11.1572C4.5625 11.5714 4.22671 11.9072 3.8125 11.9072C3.39829 11.9072 3.0625 11.5714 3.0625 11.1572V6.78223C3.0625 6.36801 3.39829 6.03223 3.8125 6.03223Z" fill="#292D32"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M15.1875 6.03223C15.6017 6.03223 15.9375 6.36801 15.9375 6.78223V11.1572C15.9375 11.5714 15.6017 11.9072 15.1875 11.9072C14.7733 11.9072 14.4375 11.5714 14.4375 11.1572V6.78223C14.4375 6.36801 14.7733 6.03223 15.1875 6.03223Z" fill="#292D32"></path>
	</symbol>
	<symbol viewBox="0 0 19 20" id="date-tanks-icon">
		<path fill-rule="evenodd" clip-rule="evenodd" d="M6 0.75C6.41421 0.75 6.75 1.08579 6.75 1.5V4.125C6.75 4.53921 6.41421 4.875 6 4.875C5.58579 4.875 5.25 4.53921 5.25 4.125V1.5C5.25 1.08579 5.58579 0.75 6 0.75Z" fill="#292D32"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M13 0.75C13.4142 0.75 13.75 1.08579 13.75 1.5V4.125C13.75 4.53921 13.4142 4.875 13 4.875C12.5858 4.875 12.25 4.53921 12.25 4.125V1.5C12.25 1.08579 12.5858 0.75 13 0.75Z" fill="#292D32"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M1.3125 7.70386C1.3125 7.28964 1.64829 6.95386 2.0625 6.95386H16.9375C17.3517 6.95386 17.6875 7.28964 17.6875 7.70386C17.6875 8.11807 17.3517 8.45386 16.9375 8.45386H2.0625C1.64829 8.45386 1.3125 8.11807 1.3125 7.70386Z" fill="#292D32"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M3.21366 4.52596C2.67449 5.1066 2.375 5.98997 2.375 7.1875V14.625C2.375 15.8225 2.67449 16.7059 3.21366 17.2865C3.74348 17.8571 4.6117 18.25 6 18.25H13C14.3883 18.25 15.2565 17.8571 15.7863 17.2865C16.3255 16.7059 16.625 15.8225 16.625 14.625V7.1875C16.625 5.98997 16.3255 5.1066 15.7863 4.52596C15.2565 3.95538 14.3883 3.5625 13 3.5625H6C4.6117 3.5625 3.74348 3.95538 3.21366 4.52596ZM2.11447 3.50529C3.00652 2.54462 4.3258 2.0625 6 2.0625H13C14.6742 2.0625 15.9935 2.54462 16.8855 3.50529C17.7682 4.4559 18.125 5.76003 18.125 7.1875V14.625C18.125 16.0525 17.7682 17.3566 16.8855 18.3072C15.9935 19.2679 14.6742 19.75 13 19.75H6C4.3258 19.75 3.00652 19.2679 2.11447 18.3072C1.23176 17.3566 0.875 16.0525 0.875 14.625V7.1875C0.875 5.76003 1.23176 4.4559 2.11447 3.50529Z" fill="#292D32"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M8.49609 11.7375C8.49609 11.1853 8.94381 10.7375 9.49609 10.7375H9.50395C10.0562 10.7375 10.504 11.1853 10.504 11.7375C10.504 12.2898 10.0562 12.7375 9.50395 12.7375H9.49609C8.94381 12.7375 8.49609 12.2898 8.49609 11.7375Z" fill="#292D32"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M5.25757 11.7375C5.25757 11.1853 5.70528 10.7375 6.25757 10.7375H6.26543C6.81771 10.7375 7.26543 11.1853 7.26543 11.7375C7.26543 12.2898 6.81771 12.7375 6.26543 12.7375H6.25757C5.70528 12.7375 5.25757 12.2898 5.25757 11.7375Z" fill="#292D32"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M5.25757 14.3625C5.25757 13.8103 5.70528 13.3625 6.25757 13.3625H6.26543C6.81771 13.3625 7.26543 13.8103 7.26543 14.3625C7.26543 14.9148 6.81771 15.3625 6.26543 15.3625H6.25757C5.70528 15.3625 5.25757 14.9148 5.25757 14.3625Z" fill="#292D32"></path>
	</symbol>
	<symbol viewBox="0 0 19 17" id="order-id-icon">
		style="background: rebeccapurple;"&gt;
		<path fill-rule="evenodd" clip-rule="evenodd" d="M2.46346 2.60868C1.89288 3.1385 1.5 4.00672 1.5 5.39502V11.52C1.5 12.9083 1.89288 13.7765 2.46346 14.3064C3.0441 14.8455 3.92747 15.145 5.125 15.145H13.875C15.0725 15.145 15.9559 14.8455 16.5365 14.3064C17.1071 13.7765 17.5 12.9083 17.5 11.52V5.39502C17.5 4.00672 17.1071 3.1385 16.5365 2.60868C15.9559 2.06951 15.0725 1.77002 13.875 1.77002H5.125C3.92747 1.77002 3.0441 2.06951 2.46346 2.60868ZM1.44279 1.50949C2.3934 0.626778 3.69753 0.27002 5.125 0.27002H13.875C15.3025 0.27002 16.6066 0.626778 17.5572 1.50949C18.5179 2.40154 19 3.72082 19 5.39502V11.52C19 13.1942 18.5179 14.5135 17.5572 15.4056C16.6066 16.2883 15.3025 16.645 13.875 16.645H5.125C3.69753 16.645 2.3934 16.2883 1.44279 15.4056C0.482115 14.5135 0 13.1942 0 11.52V5.39502C0 3.72082 0.482115 2.40154 1.44279 1.50949Z" fill="white"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M4.25 4.20752C4.66421 4.20752 5 4.54331 5 4.95752V11.9575C5 12.3717 4.66421 12.7075 4.25 12.7075C3.83579 12.7075 3.5 12.3717 3.5 11.9575V4.95752C3.5 4.54331 3.83579 4.20752 4.25 4.20752Z" fill="white"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M6.875 4.20752C7.28921 4.20752 7.625 4.54331 7.625 4.95752V8.45752C7.625 8.87173 7.28921 9.20752 6.875 9.20752C6.46079 9.20752 6.125 8.87173 6.125 8.45752V4.95752C6.125 4.54331 6.46079 4.20752 6.875 4.20752Z" fill="white"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M6.875 10.3325C7.28921 10.3325 7.625 10.6683 7.625 11.0825V11.9575C7.625 12.3717 7.28921 12.7075 6.875 12.7075C6.46079 12.7075 6.125 12.3717 6.125 11.9575V11.0825C6.125 10.6683 6.46079 10.3325 6.875 10.3325Z" fill="white"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M12.125 4.20752C12.5392 4.20752 12.875 4.54331 12.875 4.95752V5.83252C12.875 6.24673 12.5392 6.58252 12.125 6.58252C11.7108 6.58252 11.375 6.24673 11.375 5.83252V4.95752C11.375 4.54331 11.7108 4.20752 12.125 4.20752Z" fill="white"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M9.5 4.20752C9.91421 4.20752 10.25 4.54331 10.25 4.95752V11.9575C10.25 12.3717 9.91421 12.7075 9.5 12.7075C9.08579 12.7075 8.75 12.3717 8.75 11.9575V4.95752C8.75 4.54331 9.08579 4.20752 9.5 4.20752Z" fill="white"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M12.125 7.70752C12.5392 7.70752 12.875 8.04331 12.875 8.45752V11.9575C12.875 12.3717 12.5392 12.7075 12.125 12.7075C11.7108 12.7075 11.375 12.3717 11.375 11.9575V8.45752C11.375 8.04331 11.7108 7.70752 12.125 7.70752Z" fill="white"></path>
		<path fill-rule="evenodd" clip-rule="evenodd" d="M14.75 4.20752C15.1642 4.20752 15.5 4.54331 15.5 4.95752V11.9575C15.5 12.3717 15.1642 12.7075 14.75 12.7075C14.3358 12.7075 14 12.3717 14 11.9575V4.95752C14 4.54331 14.3358 4.20752 14.75 4.20752Z" fill="white"></path>
	</symbol>
</svg>
<div class="woocommerce-order woocommerce-order-vip">

	<?php
	if ($order) :
		do_action('woocommerce_before_thankyou', $order->get_id());
	?>
		<div class="min-w-[1110px] max-w-[1110px] m-auto lx:min-w-full woocommerce-order-vip">

			<?php if ($order->has_status('failed')) : ?>

				<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php esc_html_e('Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'woocommerce'); ?></p>

				<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
					<a href="<?php echo esc_url($order->get_checkout_payment_url()); ?>" class="button pay"><?php esc_html_e('Pay', 'woocommerce'); ?></a>
					<?php if (is_user_logged_in()) : ?>
						<a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>" class="button pay"><?php esc_html_e('My account', 'woocommerce'); ?></a>
					<?php endif; ?>
				</p>

			<?php else : ?>
				<div class="bg-[#F8F9FB] rounded-[7px] grid grid-cols-12 mb-9 a-sm:grid-cols-2 a-sm:mb-3 overflow-hidden">
					<div class="flex flex-col items-center before-tanku relative col-span-5 p-24 ml:p-4 a-sm:pb-10">
						<svg class="w-36 h-36 mb-6 a-sm:w-24 a-sm:h-24 a-sm:mb-2">
							<use xlink:href="#cart-tanks-icon">
							</use>
						</svg>
						<span class="text-[45px] text-[#059F50] font-bold a-sm:text-[22px]">متشکریم</span>
						<span class="text-[17px] text-[#232C37] font-bold "><?php wc_get_template('checkout/order-received.php', array('order' => $order)); ?></span>
						<span class="line-tanks"></span>
					</div>
					<ul class="woocommerce-order-overview woocommerce-thankyou-order-details order_details flex flex-col gap-3 col-span-7 p-24 ml:p-4 a-sm:pt-10">

						<li class="woocommerce-order-overview__order order">
							<?php esc_html_e('Order number:', 'woocommerce'); ?>
							<strong><?php echo $order->get_order_number(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
									?></strong>
						</li>

						<li class="woocommerce-order-overview__date date">
							<?php esc_html_e('Date:', 'woocommerce'); ?>
							<strong><?php echo wc_format_datetime($order->get_date_created()); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
									?></strong>
						</li>

						<?php if (is_user_logged_in() && $order->get_user_id() === get_current_user_id() && $order->get_billing_email()) : ?>
							<li class="woocommerce-order-overview__email email">
								<?php esc_html_e('Email:', 'woocommerce'); ?>
								<strong><?php echo $order->get_billing_email(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
										?></strong>
							</li>
						<?php endif; ?>

						<li class="woocommerce-order-overview__total total">
							<?php esc_html_e('Total:', 'woocommerce'); ?>
							<strong><?php echo $order->get_formatted_order_total(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
									?></strong>
						</li>

						<?php if ($order->get_payment_method_title()) : ?>
							<li class="woocommerce-order-overview__payment-method method">
								<?php esc_html_e('Payment method:', 'woocommerce'); ?>
								<strong><?php echo wp_kses_post($order->get_payment_method_title()); ?></strong>
							</li>
						<?php endif; ?>

					</ul>
				</div>
			<?php endif; ?>

			<?php do_action('woocommerce_thankyou_' . $order->get_payment_method(), $order->get_id()); ?>
			<?php do_action('woocommerce_thankyou', $order->get_id()); ?>

		</div>
	<?php else : ?>

		<?php wc_get_template('checkout/order-received.php', array('order' => false)); ?>

	<?php endif; ?>

</div>