<?php

/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product, $shopi_options;
?>
<div class="container 2xl m-auto">
    <?php
    /**
     * Hook: woocommerce_before_single_product.
     *
     * @hooked woocommerce_output_all_notices - 10
     */
    do_action('woocommerce_before_single_product');
    ?>
</div>
<?php
if (post_password_required()) {
    echo get_the_password_form(); // WPCS: XSS ok.
    return;
}
$_english_title = get_post_meta(get_the_ID(), '_english_title', true);
$attributes = $product->get_attributes();
$term_first = get_first_taxonomy_term(get_the_ID(), 'product_cat');
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class('', $product); ?>>
    <div class="container 2xl m-auto">
        <span class='title-head text-[14px] text-[#394454] font-bold title-line title-line-f0f2f6 pb-9 a-sm:pb-4'>
            <div class="breadcrumbs scrollbar-hide  flex items-center text-[13px] text-[#969fae] font-bold fill-[#cbd0da] w-max">
                <nav class="woocommerce-breadcrumb" aria-label="Breadcrumb">
                    <?= woocommerce_breadcrumb() ?>
                </nav>
            </div>
            <span class="line"></span>
        </span>
        <div class="mb-12 flex items-start gap-7 lx:flex-col tab:gap-4 a-sxl:mb-5 tab:mb-2">
            <div class="min-w-[465px] max-w-[465px] a-sxl:min-w-[380px] a-sxl:max-w-[380px] lx:max-w-full lx:min-w-full">
                <?php woocommerce_show_product_images() ?>
            </div>
            <div class="grow lx:w-full">
                <div class="flex items-center justify-between gap-3 mb-12 lx:mb-6 a-md:flex-col a-md:items-start">
                    <div class="flex flex-col gap-3">
                        <h1 class='text-[19px] text-[#495666] font-bold line-clamp-1 tab:line-clamp-2 tab:text-[17px] a-md:text-[18px]'><?php the_title() ?></h1>
                        <?php if (isset($_english_title) && !empty($_english_title)) { ?>
                            <span class='text-[13px] text-[#969fae] font-bold line-clamp-1'><?= @esc_attr($_english_title) ?></span>
                        <?php } ?>
                    </div>
                    <ul class="flex items-center gap-8 a-md:justify-center a-md:w-full">
                        <li class="flex items-center flex-col gap-4 cursor-pointer favorites-event-post favorites-post-single" data-id="<?= get_the_ID() ?>">
                            <svg class='fill-[#969fae] w-[15px] h-[15px]'>
                                <use xlink:href='#heart-icon'>
                            </svg>
                            <span class='text-[12px] text-[#969fae] font-bold whitespace-nowrap'>افزودن به علاقه مندی</span>
                        </li>
                        <li class="share-single-event flex items-center flex-col gap-4 cursor-pointer" data-title="<?= @get_the_title() ?>" data-url="<?= get_the_permalink() ?>" data-homeurl="<?= home_url() ?>">
                            <svg class='fill-[#969fae] w-[15px] h-[15px]'>
                                <use xlink:href='#share-icon'>
                            </svg>
                            <span class='text-[12px] text-[#969fae] font-bold'>اشتراک</span>
                        </li>
                        <?php if (!empty($product->get_sku())) { ?>
                            <li class="flex items-center flex-col gap-4">
                                <svg class='fill-[#969fae] w-[15px] h-[15px]'>
                                    <use xlink:href='#copy-clipboard-icon'>
                                </svg>
                                <span class='text-[12px] text-[#969fae] font-bold'><?= @$product->get_sku(); ?></span>
                            </li>
                        <?php } ?>
                    </ul>
                </div>
                <div class="grid grid-cols-12 gap-8 a-xl:gap-5">
                    <div class="max-w-[313px] col-span-4 lx:max-w-full a-md:order-3 a-md:col-span-6 tab:col-span-12">
                        <span class='title-line text-[14px] text-[#969fae] font-bold grow mb-4 a-md:text-[#626264] a-md:mb-2'>
                            توضیحات محصول
                            <span class="line"></span>
                        </span>
                        <div class='mb-6 min-h-[300px] flex flex-col tab:min-h-0'>
                            <div class="text-[13px] text-[#969fae] font-bold line-clamp-8 text-justify leading-[2.6] shadow-expert-single mb-2">
                                <?php the_excerpt() ?>
                            </div>
                            <?php if (!empty(get_the_content())) { ?>
                                <span data-tab="#tab-description" class='scrollToTabSingle text-[13px] text-[#969fae] font-bold flex items-center gap-4 mt-auto cursor-pointer'>مشاهده
                                    بیشتر
                                    <svg class='fill-[#969fae] w-[5px] h-[9px]'>
                                        <use xlink:href='#arrow-left-wave-icon'>
                                    </svg>
                                </span>
                            <?php } ?>
                        </div>
                        <?php if (!empty($shopi_options['title_link_under_des_single_pro']) && !empty($shopi_options['link_under_des_single_pro'])) {
                            $link_target = $shopi_options['target_link_under_des_single_pro'] == '_blank' ? ' target="_blank"' : '';
                        ?>
                            <a href="<?= @esc_attr($shopi_options['link_under_des_single_pro']) ?>" <?= $link_target ?> class="text-[15px] text-[#8e98a5] font-bold border border-[#f2f4f7] px-6 py-[21px] rounded-[9px] flex items-center gap-3 mt-auto">
                                <svg class='fill-[#969fae] w-[15px] h-[14px]'>
                                    <use xlink:href='#report-single-pro-icon'>
                                </svg>
                                <?= @esc_attr($shopi_options['title_link_under_des_single_pro']) ?>
                                <svg class='fill-[#969fae] w-[5px] h-[9px] mr-auto'>
                                    <use xlink:href='#arrow-left-wave-icon'>
                                </svg>
                            </a>
                        <?php } ?>
                    </div>
                    <div class="max-w-[320px] col-span-4 lx:max-w-full a-md:order-2 a-md:col-span-6 tab:col-span-12">
                        <span class='text-[14px] text-[#969fae] font-bold flex mb-6 a-md:text-[#626264] a-md:mb-4'>ویژگی
                            های
                            محصول</span>
                        <div class="mb-6 min-h-[300px] flex flex-col tab:min-h-0">
                            <?php if (isset($attributes) && !empty($attributes)) {
                                $i = 0 ?>
                                <ul class="flex flex-col gap-4 a-sm:gap-3 mb-2">
                                    <?php foreach ($attributes as $attribute) {
                                        if ($i == 8) {
                                            break;
                                        }
                                        $attr = $product->get_attribute($attribute->get_name());
                                        if ($attribute->get_visible()) {
                                            if ($attribute->is_taxonomy()) {
                                                $taxonomy = $attribute->get_taxonomy_object();
                                                $attr_label = $taxonomy->attribute_label;
                                            } else {
                                                $attr_label = $attribute->get_name();
                                            }
                                    ?>
                                            <li class="flex items-center justify-between gap-3">
                                                <span class='text-[13px] text-[#969fae] font-bold whitespace-nowrap'><?= @esc_html($attr_label); ?></span>
                                                <span class='text-[13px] text-[#495666] font-bold line-clamp-1 text-left'><?= @esc_html($attr); ?>
                                                </span>
                                            </li>
                                    <?php $i++;
                                        }
                                    } ?>
                                </ul>
                                <span data-tab="#tab-additional_information" class="scrollToTabSingle text-[13px] text-[#969fae] font-bold flex items-center gap-4 mt-auto cursor-pointer">مشاهده
                                    بیشتر
                                    <svg class="fill-[#969fae] w-[5px] h-[9px]">
                                        <use xlink:href="#arrow-left-wave-icon">
                                        </use>
                                    </svg>
                                </span>
                            <?php } ?>
                        </div>
                        <?php if (!wp_is_mobile()) { ?>
                            <div class="woocommerce_template_single_price_vip">
                                <?php woocommerce_template_single_price(); ?>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="grow col-span-4 a-md:order-1 a-md:col-span-12 box-price-info-single">
                        <div class="bg-[#f8f9fb] rounded-[9px] p-5 px-[22px] mb-4 tab:mb-3">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center gap-3">
                                    <ins class="text-[50px] text-secondary_text  font-bold leading-[0.5] mt-3"> <?= avg_rating_post() ?></ins>
                                    <div>
                                        <span class="text-[12px] text-[#969fae] font-bold mb-1">امتیاز
                                            محصول</span>
                                        <div class="flex items-center gap-[2px] rating-post" data-id="<?= get_the_ID() ?>">
                                            <svg data-count="1" class="fill-[#bbb6ac] w-[14px] h-[14px] item-star">
                                                <use xlink:href="#star-icon">
                                                </use>
                                            </svg>
                                            <svg data-count="2" class="fill-[#bbb6ac] w-[14px] h-[14px] item-star">
                                                <use xlink:href="#star-icon">
                                                </use>
                                            </svg>
                                            <svg data-count="3" class="fill-[#bbb6ac] w-[14px] h-[14px] item-star">
                                                <use xlink:href="#star-icon">
                                                </use>
                                            </svg>
                                            <svg data-count="4" class="fill-[#bbb6ac] w-[14px] h-[14px] item-star">
                                                <use xlink:href="#star-icon">
                                                </use>
                                            </svg>
                                            <svg data-count="5" class="fill-[#bbb6ac] w-[14px] h-[14px] item-star">
                                                <use xlink:href="#star-icon">
                                                </use>
                                            </svg>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex flex-col w-max">
                                    <span class="text-[12px] text-[#969fae] font-bold">از مجموع</span>
                                    <div class="flex items-center justify-between">
                                        <span class="text-[16px] text-secondary_text  font-bold countRating"><?= count_rating_post() ?></span>
                                        <span class="text-[12px] text-[#969fae] font-bold">رای</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php woocommerce_template_single_add_to_cart() ?>
                        <?php
                        /**
                         * Hook: woocommerce_single_product_summary.
                         *
                         * @hooked woocommerce_template_single_title - 5
                         * @hooked woocommerce_template_single_rating - 10
                         * @hooked woocommerce_template_single_price - 10
                         * @hooked woocommerce_template_single_excerpt - 20
                         * @hooked woocommerce_template_single_add_to_cart - 30
                         * @hooked woocommerce_template_single_meta - 40
                         * @hooked woocommerce_template_single_sharing - 50
                         * @hooked WC_Structured_Data::generate_product_data() - 60
                         */
                        do_action('woocommerce_single_product_summary');
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="flex items-stretch gap-8 mb-16 lx:flex-col lx:gap-2 lx:mb-6">
            <?php if (isset($term_first) && !empty($term_first)) {
                $pic = get_term_meta($term_first->term_id, 'thumbnail_id', true);
            ?>
                <a href="<?= get_term_link($term_first) ?>" class="min-w-[465px] max-w-[465px] border border-[#f2f4f7] rounded-[9px] px-10 py-9 flex items-center justify-between gap-1 a-sxl:p-6 a-sxl:min-w-[380px] a-sxl:max-w-[380px] lx:min-w-full lx:max-w-full tab:px-8 tab:py-5">
                    <?= wp_get_attachment_image($pic, 'full', false, ['class' => 'max-h-12 max-w-36 object-contain tab:max-w-16 tab:max-h-16']) ?>
                    <span class="flex items-center gap-9 <?= !$pic ? 'grow justify-between' : '' ?>">
                        <span class="flex flex-col items-end">
                            <span class='show-more-c text-[14px] text-[#495666] font-bold line-clamp-1'>مشاهده تمام محصولات</span>
                            <span class='title text-[17px] text-[#495666] font-bold line-clamp-1'><?= @esc_attr($term_first->name) ?></span>
                        </span>
                        <svg class='arrow fill-[#969fae] w-[5px] h-[9px]'>
                            <use xlink:href='#arrow-left-wave-icon'>
                        </svg>
                    </span>
                </a>
            <?php } ?>
            <?php if (isset($shopi_options['list_attr_single_product']['redux_repeater_data']) && !empty($shopi_options['list_attr_single_product']['redux_repeater_data'])) {  ?>
                <div class="grow border border-[#f2f4f7] rounded-[9px] py-8 px-10 a-sxl:p-6 a-md:p-4">
                    <div class="flex items-center gap-4 a-md:grid a-md:grid-cols-4">
                        <?php foreach ($shopi_options['list_attr_single_product']['redux_repeater_data'] as $key => $item) {
                            $item = $shopi_options['list_attr_single_product'];
                            $title = isset($item['title'][$key]) ? $item['title'][$key] : '';
                            $subtitle = isset($item['subtitle'][$key]) ? $item['subtitle'][$key] : '';
                            $pic = isset($item['pic'][$key]) ? $item['pic'][$key] : '';
                        ?>
                            <div class="item flex items-center gap-5 flex-1  a-md:col-span-2 a-md:flex-col a-md:gap-3">
                                <?= wp_get_attachment_image($pic['id'], 'full', false, ['class' => 'w-[25px] h-[25px] object-contain']) ?>
                                <span class="flex flex-col gap-2 a-md:justify-center">
                                    <span class="text-[14px] text-[#495666] font-bold line-clamp-1 a-md:text-center"><?= @esc_attr($title) ?></span>
                                    <span class="text-[13px] text-[#969fae] font-bold line-clamp-1 a-md:text-center">
                                        <?= @esc_attr($subtitle) ?>
                                    </span>
                                </span>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
        </div>
        <div class="flex gap-8 lx:flex-col-reverse mb-9 a-sm:mb-4">
            <div class="grow relative">
            <?php
                /**
                 * Hook: woocommerce_after_single_product_summary.
                 *
                 * @hooked woocommerce_output_product_data_tabs - 10
                 * @hooked woocommerce_upsell_display - 15
                 * @hooked woocommerce_output_related_products - 20
                 */
                woocommerce_output_product_data_tabs();
                do_action( 'woocommerce_after_single_product_summary' );
                ?>
            </div>
            <?php if (!isset($shopi_options['disable_single_product_sidebar']) || !$shopi_options['disable_single_product_sidebar']) { ?>
                <?php if (!wp_is_mobile()) { ?>
                    <?php set_query_var('product', $product); ?>
                    <div class="sidebar-shop-container min-w-[306px] max-w-[306px] lx:min-w-full lx:max-w-full">
                        <div class="sticky top-1">
                            <?php get_template_part('template-parts/single-product/sidebar-shop') ?>
                        </div>
                    </div>
                <?php } ?>
            <?php } ?>
            <?php
            $product = wc_get_product(get_the_ID());
            ?>
        </div>
        <div>

            <?php woocommerce_output_related_products() ?>
        </div>
    </div>
</div>

<?php do_action('woocommerce_after_single_product'); ?>