<?php

/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.4.0
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

$allowed_html = array(
	'a' => array(
		'href' => array(),
	),
);

$user_id = get_current_user_id();
$billing_first_name = @get_user_meta($user_id, 'billing_first_name', true);
$billing_last_name = @get_user_meta($user_id, 'billing_last_name', true);
$billing_address_1 = @get_user_meta($user_id, 'billing_address_1', true);
$billing_city = @get_user_meta($user_id, 'billing_city', true);
$billing_state_code = @get_user_meta($user_id, 'billing_state', true);
$billing_postcode = @get_user_meta($user_id, 'billing_postcode', true);
$billing_phone = @get_user_meta($user_id, 'billing_phone', true);
$billing_email = @get_user_meta($user_id, 'billing_email', true);

$billing_country = @get_user_meta($user_id, 'billing_country', true);
$billing_state_name = @WC()->countries->get_states($billing_country)[$billing_state_code];
$billing_city_name = @WC()->countries->get_states($billing_country)[$billing_city];

$the_query_post = new WP_Query(array(
	'post_type'      => 'post',
	'order'          => 'DESC',
	'post_status'    => 'publish',
	'post__in' => get_visited_list('post'),
	'posts_per_page' => 5
));

$the_query_product = new WP_Query([
	'post_type'      => 'product',
	'order'          => 'DESC',
	'post_status'    => 'publish',
	'post__in' => get_visited_list('product'),
	'posts_per_page' => 5
]);

$the_query_cat = new WP_Term_Query([
	'taxonomy'               => 'product_cat',
	'orderby'                => 'name',
	'order'                  => 'ASC',
	'hide_empty'             => false,
	'include' => get_visited_list('product_cat'),
	'number' => 5

]);

$the_query_notifications = new WP_Query([
	'post_type'      => 'notifications',
	'order'          => 'DESC',
	'post_status'    => 'publish',
	'posts_per_page' => 4
]);


?>
<div>
	<div class="flex items-center justify-between border-[#f2f4f7] border-b pb-6 mb-6 tab:mb-4 tab:pb-4">
		<span class='text-[17px] text-[#768699] font-bold tab:text-[15px]'>پیشخوان</span>
		<a href="<?= wc_get_account_endpoint_url('edit-account') ?>" class='text-[13px] text-[#969fae] font-bold flex items-center gap-2 tab:text-[12px]'>
			ویرایش اطلاعات پروفایل
			<svg class='fill-[#969fae] w-3 h-3'>
				<use xlink:href='#edit-icon'>
			</svg>
		</a>
	</div>
	<div class="alarm-dashboard bg-[#feeff1] text-[14px] text-[#975a62] font-bold flex items-center justify-between p-7 py-6 rounded-[7px] mb-7 lx:py-4 tab:text-[13px] tab:mb-5">
		<p>
			<?php
			/* translators: 1: Orders URL 2: Address URL 3: Account URL. */
			$dashboard_desc = __('From your account dashboard you can view your <a href="%1$s">recent orders</a>, manage your <a href="%2$s">billing address</a>, and <a href="%3$s">edit your password and account details</a>.', 'woocommerce');
			if (wc_shipping_enabled()) {
				/* translators: 1: Orders URL 2: Addresses URL 3: Account URL. */
				$dashboard_desc = __('From your account dashboard you can view your <a href="%1$s">recent orders</a>, manage your <a href="%2$s">shipping and billing addresses</a>, and <a href="%3$s">edit your password and account details</a>.', 'woocommerce');
			}
			printf(
				wp_kses($dashboard_desc, $allowed_html),
				esc_url(wc_get_endpoint_url('orders')),
				esc_url(wc_get_endpoint_url('edit-address')),
				esc_url(wc_get_endpoint_url('edit-account'))
			);
			?>
		</p>
		<svg class='fill-[#debfc3] w-[18px] h-[16px]'>
			<use xlink:href='#alarm-icon'>
		</svg>
	</div>
	<div class="grid grid-cols-12 gap-16 lx:gap-7 ml:grid-cols-2">
		<div class="col-span-6 gap-14">
			<span class='title-head text-[13px] text-[#8c96a2] font-bold title-line pb-5'>
				اطلاعات شخصی من
				<span class="line"></span>
			</span>
			<ul class="grid grid-cols-3 gap-y-11 gap-x-4 mb-12 tab:grid-cols-2 tab:gap-y-4 tab:mb-7">
				<li class="flex flex-col gap-2">
					<span class='text-[12px] text-[#969fae] font-bold'>نام و نام خانوادگی</span>
					<span class='text-[16px] text-[#495666] font-bold line-clamp-1 lx:text-[14px]'>
						<?= $billing_first_name || $billing_last_name ? esc_attr($billing_first_name) . " " . @esc_attr($billing_last_name) : "-----" ?>
					</span>
				</li>
				<li class="flex flex-col gap-2">
					<span class='text-[12px] text-[#969fae] font-bold'>شماره همراه</span>
					<span class='text-[16px] text-[#495666] font-bold line-clamp-1 lx:text-[14px]'>
						<?= $billing_phone ? esc_attr($billing_phone) : "-----" ?>
					</span>
				</li>
				<li class="flex flex-col gap-2">
					<span class='text-[12px] text-[#969fae] font-bold'>ایمیل</span>
					<span class='text-[15px] text-[#495666] font-bold line-clamp-1 lx:text-[14px]'>
						<?= $billing_email ? esc_attr($billing_email) : "-----" ?>
					</span>
				</li>
				<li class="flex flex-col gap-2">
					<span class='text-[12px] text-[#969fae] font-bold'>استان</span>
					<span class='text-[16px] text-[#495666] font-bold line-clamp-1 lx:text-[14px]'>
						<?= $billing_state_name ? esc_attr($billing_state_name) : "-----" ?>
					</span>
				</li>
				<li class="flex flex-col gap-2">
					<span class='text-[12px] text-[#969fae] font-bold'>شهر</span>
					<span class='text-[16px] text-[#495666] font-bold line-clamp-1 lx:text-[14px]'>
						<?= $billing_city_name ? esc_attr($billing_city_name) : "-----" ?>
					</span>
				</li>
				<li class="flex flex-col gap-2">
					<span class='text-[12px] text-[#969fae] font-bold'>کدپستی</span>
					<span class='text-[16px] text-[#495666] font-bold line-clamp-1 lx:text-[14px]'>
						<?= $billing_postcode ? esc_attr($billing_postcode) : "-----" ?>
					</span>
				</li>
				<li class="flex gap-6 col-span-3 tab:col-span-2 tab:flex-col tab:gap-2">
					<span class='text-[12px] text-[#969fae] font-bold'>آدرس</span>
					<span class='text-[14px] text-[#495666] font-bold line-clamp-1 lx:text-[13px]'>
						<?= $billing_address_1 ? esc_attr($billing_address_1) : "-----" ?>
					</span>
				</li>
			</ul>
			<span class='title-head text-[13px] text-[#8c96a2] font-bold title-line pb-7 tab:pb-5'>
				اطلاعیه ها
				<span class="line"></span>
			</span>
			<?php if ($the_query_notifications->have_posts()) { ?>
				<ul class="flex flex-col gap-5 tab:gap-4">
					<?php while ($the_query_notifications->have_posts()) {
						$the_query_notifications->the_post();
					?>
						<li>
							<span class='text-[14px] text-[#495666] font-bold flex items-center gap-4 justify-between lx:text-[13px] tab:text-[12px]'>
								<span class="line-clamp-1">
									<?php the_title() ?>
								</span>
								<span class='text-[12px] text-[#969fae] font-bold whitespace-nowrap'>
									<?= humanTiming(get_post_time()) ?>
								</span>
							</span>
						</li>
					<?php } ?>
				</ul>
			<?php
				wp_reset_query();
				wp_reset_postdata();
			} else { ?>
				<?php print_msg('اطلاعیه ای وجود ندارد') ?>
			<?php } ?>
		</div>
		<div class="col-span-6">
			<span class="title-head text-[13px] text-[#8c96a2] font-bold title-line pb-7 tab:pb-5">
				بازدیدهای اخیر
				<span class="line"></span>
			</span>
			<?php if (!empty($the_query_cat->terms)) { ?>
				<div class="swiper-list-cat swiper-list-cat-archive swiper pb-7 a-md:pb-3">
					<div class="swiper-wrapper">
						<?php foreach ($the_query_cat->get_terms() as $term) {
							$pic = get_term_meta($term->term_id, 'thumbnail_id', true);
						?>
							<div class="swiper-slide w-max">
								<a href="<?= get_term_link($term) ?>" class="item flex items-center gap-4 border border-[#f2f4f7] rounded-[7px] bg-white px-6 py-5 min-w-[231px] cursor-pointer a-md:p-3 a-md:min-w-[180px]">
									<span class='flex flex-col gap-1 grow'>
										<span class="text-[15px] text-[#495666] font-bold line-clamp-1 title transition-3s">
											<?= @esc_attr($term->name) ?>
										</span>
										<span class='text-[13px] text-[#969fae] line-clamp-1 font-bold'><?= @esc_attr($term->count) ?> محصول</span>
									</span>
									<svg class="fill-[#969fae] w-[5px] h-[9px] icon-cat transition-3s">
										<use xlink:href="#arrow-left-wave-icon">
										</use>
									</svg>
								</a>
							</div>
						<?php } ?>
					</div>
				</div>
			<?php } ?>
			<?php if ($the_query_product->have_posts()) { ?>
				<div class="swiper swiper-recent mb-5">
					<div class="swiper-wrapper">
						<?php while ($the_query_product->have_posts()) {
							$the_query_product->the_post();
						?>
							<div class="swiper-slide w-max">
								<a href="<?php the_permalink() ?>" class="border border-[#f2f4f7] rounded-[7px] px-5 py-6 min-w-[231px] max-w-[231px] h-[245px] flex flex-col">
									<?php if (has_post_thumbnail()) {
										echo get_the_post_thumbnail(get_the_ID(), 'full', ['class' => 'w-full object-contain max-h-[100px] min-h-[100px] m-auto mb-3']);
									} else {
										echo wc_placeholder_img('full', ['class' => 'w-full object-contain max-h-[100px] min-h-[100px] m-auto mb-3']);
									} ?>
									<span class='text-[15px] text-[#394454] font-bold line-clamp-1 mt-auto'>
										<?php the_title() ?>
									</span>
									<span class='text-[12px] text-[#8c98a5] font-bold line-clamp-1'></span>
								</a>
							</div>
						<?php } ?>
					</div>
				</div>
			<?php
				wp_reset_query();
				wp_reset_postdata();
			} ?>
			<?php if ($the_query_post->have_posts()) { ?>
				<div class="swiper swiper-recent-blog">
					<div class="swiper-wrapper">
						<?php while ($the_query_post->have_posts()) {
							$the_query_post->the_post();
						?>
							<div class="swiper-slide w-max">
								<a href="<?php the_permalink() ?>" class="border border-[#f2f4f7] rounded-[7px] px-[22px] py-3 flex items-center justify-between gap-5 min-w-[381px] max-w-[381px] a-mob:min-w-[0] mob:px-3">
									<span class='text-[13px] text-[#495666] font-bold line-clamp-1 mob:text-[13px]'>
										<?php the_title() ?>
									</span>
									<span class='text-[11px] text-[#84aa98] font-bold flex flex-col items-center leading-[1]'>
										<ins class='text-[21px] text-[#00a651] font-bold mob:text-[19px]'><?= reading_time(get_the_ID()) ?></ins>
										دقیقه
									</span>
								</a>
							</div>
						<?php } ?>
					</div>
				</div>
			<?php
				wp_reset_query();
				wp_reset_postdata();
			} ?>
		</div>
	</div>
</div>

<?php
/**
 * My Account dashboard.
 *
 * @since 2.6.0
 */
do_action('woocommerce_account_dashboard');

/**
 * Deprecated woocommerce_before_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action('woocommerce_before_my_account');

/**
 * Deprecated woocommerce_after_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action('woocommerce_after_my_account');

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
