<?php

/**
 * My Account page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.5.0
 */

defined('ABSPATH') || exit;
?>
<svg width="0" height="0" class="hidden">
	<symbol viewBox="0 0 16 15" id="dashboard-icon">
		<path xmlns="http://www.w3.org/2000/svg" d="m0.6 0.8c0-0.4 0.3-0.7 0.8-0.7h5c0.4 0 0.7 0.3 0.7 0.7v5.1c0 0.4-0.3 0.7-0.7 0.7h-5c-0.5 0-0.8-0.3-0.8-0.7zm1.5 0.7v3.6h3.6v-3.6zm6.5-0.7c0-0.5 0.3-0.7 0.7-0.7h5.1c0.4 0 0.7 0.2 0.7 0.7v5c0 0.5-0.3 0.8-0.7 0.8h-5.1c-0.4 0-0.7-0.3-0.7-0.8zm1.4 0.8v3.6h3.7v-3.6zm-1.5 7.2c0-0.4 0.3-0.7 0.7-0.7h5.1c0.4 0 0.7 0.3 0.7 0.7v5.1c0 0.4-0.3 0.7-0.7 0.7h-5.1c-0.4 0-0.7-0.3-0.7-0.7zm1.5 0.7v3.6h3.6v-3.6zm-9.4-0.7c0-0.5 0.3-0.8 0.7-0.8h5.1c0.4 0 0.7 0.3 0.7 0.8v5c0 0.5-0.3 0.7-0.7 0.7h-5.1c-0.4 0-0.7-0.2-0.7-0.7zm1.4 0.7v3.7h3.6v-3.7z"></path>
	</symbol>
	<symbol viewBox="0 0 17 18" id="orders-icon">
		<path xmlns="http://www.w3.org/2000/svg" d="m16.5 4.3c-0.2-0.3-0.5-0.6-0.9-0.8l-5.8-2.9-0.3 0.7 0.3-0.7c-0.3-0.1-0.6-0.2-0.9-0.2-0.3 0-0.7 0.1-1 0.2l-5.7 2.9c-0.4 0.2-0.7 0.5-0.9 0.8-0.2 0.4-0.4 0.7-0.4 1.2v6.8c0 0.5 0.1 0.8 0.3 1.2 0.2 0.4 0.5 0.7 0.9 0.8l5.8 2.9c0.3 0.1 0.6 0.2 0.9 0.2 0.4 0 0.7-0.1 1-0.2l5.7-2.9c0.4-0.1 0.7-0.4 0.9-0.8 0.2-0.4 0.4-0.7 0.4-1.2v-6.8c0-0.5-0.1-0.9-0.3-1.2zm-7.9-2.4c0.1-0.1 0.2-0.1 0.3-0.1 0.1 0 0.2 0 0.3 0.1l5.3 2.6-5.7 2.9-5.6-2.9zm-5.9 11.2c-0.1-0.1-0.2-0.2-0.3-0.3 0-0.2 0-0.2 0-0.4v-6.6l5.7 2.9v7.1zm12.6-0.3c-0.1 0.2-0.2 0.3-0.3 0.3l-5.4 2.7v-7.1l5.8-2.9v6.7c0 0.1-0.1 0.2-0.1 0.3z"></path>
	</symbol>
	<symbol viewBox="0 0 17 15" id="interested-icon">
		<path xmlns="http://www.w3.org/2000/svg" d="m10.3 0.4c0.6-0.2 1.2-0.4 1.8-0.4 0.7 0 1.3 0.2 1.8 0.4 0.6 0.2 1.1 0.6 1.6 1 0.4 0.4 0.8 0.9 1 1.5 0.2 0.6 0.3 1.2 0.3 1.8 0 0.7-0.1 1.3-0.3 1.8-0.2 0.6-0.6 1.1-1 1.6l-6.4 6.3c-0.3 0.3-0.7 0.3-1 0l-6.4-6.3c-0.9-0.9-1.4-2.1-1.4-3.4 0-1.2 0.5-2.4 1.4-3.3 0.9-0.9 2.1-1.4 3.3-1.4 1.3 0 2.5 0.5 3.4 1.4l0.3 0.3 0.2-0.3c0.3-0.4 0.8-0.8 1.4-1zm1.8 1.1c-0.4 0-0.8 0-1.2 0.2-0.4 0.1-0.7 0.4-1.1 0.7l-0.8 0.8c-0.3 0.3-0.7 0.3-1 0l-0.8-0.8c-0.6-0.6-1.4-0.9-2.3-0.9-0.9 0-1.7 0.3-2.3 0.9-0.6 0.6-1 1.5-1 2.3 0 0.9 0.4 1.7 1 2.3l5.8 5.9 5.9-5.9c0.3-0.2 0.6-0.6 0.7-1 0.2-0.4 0.2-0.8 0.2-1.3 0-0.4 0-0.8-0.2-1.2-0.1-0.4-0.4-0.7-0.7-1.1-0.3-0.3-0.7-0.6-1.1-0.7-0.4-0.2-0.6-0.2-1.1-0.2z"></path>
	</symbol>
	<symbol viewBox="0 0 16 15" id="comment-icon">
		<path xmlns="http://www.w3.org/2000/svg" d="m3 1.5c-0.2 0-0.4 0-0.5 0.2-0.2 0.1-0.3 0.3-0.3 0.5v9.8l1.7-1.6c0.2-0.2 0.3-0.3 0.5-0.3h8.7c0.2 0 0.4 0 0.5-0.2 0.1-0.1 0.2-0.3 0.2-0.5v-7.2c0-0.2-0.1-0.4-0.2-0.5-0.1-0.2-0.3-0.2-0.5-0.2zm-1.5-0.8q0.6-0.7 1.5-0.7h10.1c0.6 0 1.2 0.2 1.5 0.7 0.4 0.4 0.7 0.9 0.7 1.5v7.2c0 0.6-0.2 1.2-0.7 1.5-0.4 0.4-0.9 0.7-1.5 0.7h-8.4l-2.6 2.7c-0.3 0.2-0.6 0.3-0.8 0.1q-0.5-0.2-0.5-0.6v-11.6c0-0.6 0.2-1.2 0.7-1.5z"></path>
	</symbol>
	<symbol viewBox="0 0 15 18" id="map-icon">
		<path xmlns="http://www.w3.org/2000/svg" d="m7.7 2.2c-1.6 0-3.1 0.6-4.2 1.6-1 1.1-1.6 2.6-1.6 4.2 0 2.2 1.4 4.4 3 6 0.8 0.8 1.6 1.5 2.2 2 0.2 0.1 0.4 0.3 0.6 0.4 0.1-0.1 0.3-0.3 0.5-0.4 0.6-0.5 1.4-1.2 2.2-2 1.6-1.6 3-3.8 3-6 0-1.6-0.5-3.1-1.6-4.2-1.1-1-2.6-1.6-4.1-1.6zm-0.5 15.7c0 0 0 0 0 0-0.1 0-0.2-0.1-0.3-0.2-0.2-0.1-0.4-0.3-0.8-0.6-0.6-0.5-1.4-1.2-2.3-2.1-1.6-1.7-3.4-4.2-3.4-7 0-2 0.7-3.8 2.1-5.2 1.3-1.4 3.1-2.1 5.1-2.1 1.9 0 3.7 0.8 5.1 2.1 1.4 1.3 2.1 3.2 2.1 5.2 0 2.8-1.8 5.3-3.5 7-0.8 0.9-1.6 1.6-2.3 2.1-0.3 0.3-0.5 0.5-0.8 0.6q-0.1 0.1-0.2 0.2h0.1c-0.1 0.1-0.1 0-0.2 0 0.1 0 0.2 0 0.1 0 0 0-0.1 0-0.1 0.1-0.2 0.1-0.4 0.1-0.6-0.1l0.4-0.5c-0.5 0.5-0.5 0.5-0.5 0.5zm0.8 0l-0.3-0.5c0.2 0.2 0.3 0.4 0.3 0.5q0 0 0 0 0 0 0 0zm-0.3-11.4c-0.8 0-1.5 0.7-1.5 1.5 0 0.8 0.7 1.4 1.5 1.4 0.8 0 1.4-0.6 1.4-1.4 0-0.8-0.6-1.5-1.4-1.5zm-2.9 1.5c0-1.6 1.3-2.9 2.9-2.9 1.5 0 2.8 1.3 2.8 2.9 0 1.5-1.3 2.8-2.8 2.8-1.6 0-2.9-1.3-2.9-2.8z"></path>
	</symbol>
	<symbol viewBox="0 0 18 18" id="setting-icon">
		<path xmlns="http://www.w3.org/2000/svg" d="m9.4 7.9c-0.8 0-1.4 0.7-1.4 1.4 0 0.8 0.6 1.5 1.4 1.5 0.8 0 1.5-0.7 1.5-1.5 0-0.7-0.7-1.4-1.5-1.4zm-2.9 1.4c0-1.5 1.3-2.8 2.9-2.8 1.6 0 2.9 1.3 2.9 2.8 0 1.6-1.3 2.9-2.9 2.9-1.6 0-2.9-1.3-2.9-2.9zm2.9-7.2c-0.2 0-0.3 0.1-0.5 0.2-0.1 0.2-0.2 0.3-0.2 0.5v0.2c0 0.3-0.2 0.7-0.3 1.1-0.2 0.3-0.5 0.5-0.9 0.7 0 0-0.1 0.1-0.2 0.1-0.3 0.1-0.6 0.1-0.9 0-0.4 0-0.7-0.2-1-0.5h-0.1c-0.1-0.1-0.2-0.2-0.2-0.2-0.1-0.1-0.2-0.1-0.3-0.1-0.1 0-0.2 0-0.3 0.1-0.1 0-0.1 0.1-0.2 0.2-0.1 0-0.2 0.1-0.2 0.2 0 0 0 0.2 0 0.3 0 0 0 0.2 0 0.3 0.1 0 0.1 0.1 0.2 0.2h0.1c0.2 0.3 0.4 0.7 0.5 1.1 0 0.3 0 0.7-0.2 1q-0.2 0.6-0.6 0.9c-0.3 0.2-0.7 0.4-1.1 0.4h-0.1c-0.2 0-0.4 0-0.5 0.2-0.1 0.1-0.2 0.3-0.2 0.5 0 0.2 0.1 0.4 0.2 0.5 0.1 0.1 0.3 0.2 0.5 0.2h0.2c0.3 0 0.7 0.2 1 0.3 0.3 0.2 0.6 0.5 0.8 0.9 0.1 0.3 0.2 0.7 0.1 1.1-0.1 0.3-0.2 0.7-0.5 1h-0.1c0 0.1-0.1 0.2-0.1 0.3 0 0-0.1 0.2-0.1 0.2 0 0.1 0 0.3 0.1 0.3 0.1 0.1 0.1 0.2 0.1 0.3 0.1 0 0.2 0.1 0.2 0.1 0.1 0.1 0.3 0.1 0.3 0.1 0.1 0 0.2 0 0.3-0.1 0.1 0 0.2-0.1 0.2-0.1l0.1-0.1c0.3-0.3 0.7-0.5 1-0.5 0.4-0.1 0.7 0 1.1 0.1q0.5 0.2 0.9 0.7c0.2 0.3 0.3 0.6 0.3 1.1 0 0.2 0.1 0.4 0.3 0.5 0.1 0.2 0.2 0.3 0.5 0.3 0.2 0 0.3-0.1 0.5-0.3 0.1-0.1 0.2-0.3 0.2-0.5v-0.1c0-0.4 0.1-0.7 0.3-1.1 0.2-0.3 0.5-0.6 0.8-0.7 0.4-0.2 0.8-0.2 1.1-0.2 0.4 0.1 0.7 0.2 1 0.5l0.1 0.1c0.1 0.1 0.2 0.2 0.2 0.2 0.1 0 0.2 0 0.3 0 0.1 0 0.2 0 0.3 0 0.1 0 0.1-0.1 0.2-0.2 0.1-0.1 0.2-0.1 0.2-0.2 0-0.1 0-0.2 0-0.3 0-0.1 0-0.2 0-0.3-0.1-0.1-0.1-0.1-0.2-0.2l-0.1-0.1c-0.2-0.3-0.4-0.6-0.5-1 0-0.3 0-0.8 0.2-1.1 0.1-0.3 0.3-0.6 0.7-0.8 0.3-0.3 0.7-0.3 1.1-0.3h-0.1c0.2 0 0.4-0.1 0.5-0.2 0.2-0.2 0.2-0.3 0.2-0.6 0-0.2 0-0.3-0.2-0.5-0.1-0.1-0.3-0.2-0.5-0.2h-0.1c-0.4 0-0.7-0.1-1.1-0.3-0.3-0.2-0.6-0.5-0.7-0.8 0-0.1-0.1-0.2-0.1-0.2-0.1-0.3-0.1-0.7-0.1-1 0.1-0.4 0.2-0.7 0.5-1l0.1-0.1c0.1 0 0.1-0.1 0.1-0.2 0.1-0.1 0.1-0.2 0.1-0.3 0-0.1 0-0.2-0.1-0.3 0 0 0-0.1-0.1-0.2-0.1-0.1-0.1-0.1-0.2-0.1-0.1-0.1-0.2-0.1-0.3-0.1-0.1 0-0.2 0-0.3 0.1-0.1 0-0.1 0-0.2 0.1l-0.1 0.1c-0.3 0.3-0.6 0.4-1 0.5-0.4 0.1-0.8 0-1.1-0.2-0.3-0.1-0.6-0.3-0.8-0.7-0.3-0.3-0.3-0.6-0.3-1.1 0-0.2-0.1-0.3-0.3-0.5-0.1-0.1-0.2-0.2-0.4-0.2zm6 10c0 0.1 0.1 0.1 0.2 0.2v0.1c0.3 0.2 0.4 0.4 0.5 0.7 0.2 0.3 0.2 0.6 0.2 0.8 0 0.3-0.1 0.6-0.2 0.8-0.1 0.3-0.2 0.5-0.5 0.7-0.2 0.2-0.4 0.4-0.7 0.5-0.3 0.2-0.6 0.2-0.8 0.2-0.3 0-0.6-0.1-0.8-0.2-0.3-0.1-0.5-0.3-0.7-0.5l-0.1-0.1c0 0-0.1 0-0.2-0.1-0.1 0-0.2 0-0.3 0-0.1 0-0.1 0.1-0.2 0.1-0.1 0.1-0.1 0.2-0.1 0.3v0.2c0 0.6-0.2 1.1-0.6 1.5-0.5 0.4-1 0.7-1.5 0.7-0.6 0-1.2-0.3-1.6-0.7q-0.6-0.6-0.6-1.5v-0.1c0-0.1 0-0.2-0.1-0.3-0.1-0.1-0.1-0.1-0.2-0.1 0 0 0 0-0.1 0 0-0.1-0.2-0.1-0.3 0 0 0-0.1 0-0.2 0.1v0.1c-0.3 0.2-0.5 0.4-0.8 0.5-0.3 0.1-0.6 0.1-0.8 0.1-0.3 0-0.5 0-0.8-0.1-0.3-0.1-0.5-0.3-0.7-0.5-0.2-0.2-0.3-0.4-0.5-0.7-0.1-0.3-0.1-0.6-0.1-0.8 0-0.2 0-0.6 0.1-0.8 0.2-0.3 0.3-0.5 0.5-0.7l0.1-0.1c0.1-0.1 0.1-0.2 0.1-0.2 0-0.1 0-0.2 0-0.3 0-0.1 0-0.2-0.1-0.2-0.1-0.1-0.2-0.1-0.3-0.1h-0.3c-0.6 0-1.2-0.2-1.5-0.7q-0.7-0.6-0.7-1.5c0-0.6 0.3-1.1 0.7-1.5q0.6-0.6 1.5-0.6h0.1c0.1 0 0.2 0 0.3-0.1 0-0.1 0.1-0.2 0.1-0.2 0 0 0 0 0-0.1 0.1-0.1 0.1-0.2 0-0.3 0-0.1-0.1-0.1-0.1-0.2l-0.1-0.1c-0.2-0.2-0.4-0.4-0.5-0.7-0.2-0.3-0.2-0.6-0.2-0.8 0-0.3 0.1-0.6 0.2-0.8 0.1-0.3 0.3-0.5 0.5-0.7 0.2-0.2 0.4-0.4 0.7-0.5 0.3-0.2 0.6-0.2 0.8-0.2 0.3 0 0.6 0.1 0.8 0.2 0.2 0 0.5 0.3 0.7 0.5h0.1c0.1 0.1 0.2 0.1 0.2 0.2 0.1 0 0.2 0 0.3 0 0.1 0 0.1 0 0.2-0.1 0 0 0-0.1 0.1-0.1 0.1-0.1 0.1-0.2 0.1-0.3v-0.2c0-0.5 0.2-1.1 0.6-1.5q0.7-0.6 1.5-0.6c0.6 0 1.2 0.2 1.6 0.6 0.3 0.5 0.6 1 0.6 1.5v0.1c0 0.1 0 0.2 0.1 0.3 0.1 0.1 0.1 0.1 0.2 0.1 0.1 0.1 0.2 0.1 0.3 0 0.1 0 0.1 0 0.2-0.1l0.1-0.1c0.2-0.2 0.4-0.3 0.7-0.5 0.3-0.1 0.6-0.1 0.8-0.1 0.3 0 0.6 0 0.8 0.1 0.3 0.2 0.5 0.3 0.7 0.5 0.2 0.2 0.4 0.5 0.5 0.8 0.2 0.2 0.2 0.5 0.2 0.7 0 0.3-0.1 0.6-0.2 0.8-0.1 0.3-0.3 0.5-0.5 0.8h-0.1c0 0.1 0 0.2-0.1 0.3 0 0 0 0.2 0 0.2 0 0.1 0.1 0.1 0.1 0.2 0 0.1 0 0.1 0.1 0.1 0.1 0.1 0.2 0.1 0.3 0.1h0.2c0.6 0 1.2 0.2 1.5 0.7 0.4 0.4 0.7 0.9 0.7 1.5 0 0.6-0.2 1.1-0.7 1.5-0.4 0.4-0.9 0.7-1.5 0.7-0.1 0-0.2 0-0.3 0.1-0.1 0.1-0.2 0.1-0.2 0.2-0.1 0.1-0.1 0.2 0 0.3z"></path>
	</symbol>
	<symbol viewBox="0 0 19 14" id="view-icon">
		<path xmlns="http://www.w3.org/2000/svg" d="m18.1 7.2l-0.7-0.2c0.7 0.2 0.7 0.2 0.7 0.3v0.1c-0.1 0.1-0.1 0.1-0.2 0.2-0.1 0.2-0.2 0.4-0.4 0.7-0.4 0.6-0.9 1.3-1.6 2.1-1.5 1.5-3.6 3.1-6.4 3.1-2.8 0-4.9-1.6-6.3-3.1-0.8-0.8-1.3-1.5-1.7-2.1-0.2-0.3-0.3-0.6-0.4-0.7-0.1-0.1-0.2-0.1-0.2-0.2 0-0.1 0-0.1 0-0.1q-0.1-0.3 0-0.6v-0.1c0.1-0.1 0.1-0.1 0.2-0.2 0.1-0.2 0.2-0.4 0.4-0.7 0.4-0.6 0.9-1.3 1.7-2.1 1.4-1.5 3.5-3.1 6.3-3.1 2.8 0 4.9 1.6 6.4 3.1 0.7 0.8 1.2 1.5 1.6 2.1 0.2 0.3 0.4 0.6 0.4 0.7 0.1 0.1 0.2 0.1 0.2 0.2q0.1 0.3 0 0.6zm-8.5-2.4c1.2 0 2.2 0.9 2.2 2.2 0 1.2-1 2.2-2.2 2.2-1.2 0-2.2-1-2.2-2.2 0-1.3 1-2.2 2.2-2.2zm6.9 2.2c-0.1-0.2-0.2-0.3-0.3-0.5-0.3-0.5-0.8-1.2-1.4-1.9-1.3-1.3-3.1-2.6-5.3-2.6-2.2 0-4 1.3-5.3 2.6-0.6 0.7-1.1 1.4-1.4 1.9-0.1 0.2-0.1 0.3-0.3 0.5 0.1 0.1 0.2 0.2 0.3 0.5 0.4 0.5 0.8 1.2 1.4 1.8 1.3 1.4 3.1 2.7 5.3 2.7 2.2 0 4-1.3 5.3-2.7 0.6-0.6 1.1-1.3 1.4-1.8 0.2-0.3 0.2-0.4 0.3-0.5z"></path>
	</symbol>
	<symbol viewBox="0 0 15 16" id="off-icon">
		<path xmlns="http://www.w3.org/2000/svg" d="m3.8 3.5c0.3 0.3 0.3 0.8 0 1.1-0.8 0.7-1.4 1.8-1.6 2.9-0.2 1.2-0.1 2.3 0.4 3.3 0.4 1.1 1.1 2 2.1 2.6 0.9 0.7 2.1 1 3.1 1 1.1 0 2.3-0.4 3.2-1 1-0.6 1.7-1.5 2.1-2.6 0.4-1 0.6-2.2 0.4-3.3-0.2-1.1-0.8-2.2-1.6-2.9-0.3-0.3-0.3-0.8 0-1.1 0.3-0.3 0.7-0.3 1 0 1 1.1 1.7 2.4 2 3.7 0.2 1.4 0.1 2.9-0.5 4.2-0.6 1.3-1.4 2.5-2.7 3.3-1.1 0.8-2.6 1.2-4 1.2-1.5 0-2.8-0.4-4.1-1.2-1.1-0.8-2.1-2-2.6-3.3-0.6-1.3-0.8-2.7-0.5-4.2 0.3-1.3 1-2.7 2-3.7q0.9-0.4 1.3 0zm4.1-3.5c0.4 0 0.7 0.3 0.7 0.7v7.2c0 0.5-0.3 0.8-0.7 0.8-0.4 0-0.7-0.3-0.7-0.8v-7.2c0-0.4 0.3-0.7 0.7-0.7z"></path>
	</symbol>
	<symbol viewBox="0 0 18 19" id="delete-icon">
		<path xmlns="http://www.w3.org/2000/svg" d="m0.5 4.4c0-0.4 0.4-0.8 0.9-0.8h3.4v-0.9q0-1 0.7-1.8c0.4-0.5 1.1-0.7 1.8-0.7h3.4q1 0 1.8 0.7c0.5 0.5 0.7 1.1 0.7 1.8v0.9h3.4c0.5 0 0.9 0.4 0.9 0.8 0 0.4-0.4 0.9-0.9 0.9h-0.8v11c0 0.7-0.4 1.3-0.8 1.8-0.4 0.5-1.1 0.7-1.8 0.7h-8.4q-1.1 0-1.8-0.7c-0.5-0.5-0.8-1.1-0.8-1.8v-11h-0.8c-0.5 0-0.9-0.5-0.9-0.9zm11-1.7c0-0.2 0-0.4-0.2-0.6-0.2-0.1-0.3-0.2-0.6-0.2h-3.4c-0.3 0-0.4 0.1-0.6 0.2-0.2 0.2-0.2 0.4-0.2 0.6v0.9h5zm-7.6 13.5c0 0.3 0.1 0.5 0.3 0.6 0.1 0.2 0.3 0.3 0.6 0.3h8.4c0.3 0 0.5-0.1 0.6-0.3 0.2-0.1 0.3-0.3 0.3-0.6v-11h-10.2z"></path>
	</symbol>
	<symbol viewBox="0 0 10 6" id="arrow-btn-icon">
		<path xmlns="http://www.w3.org/2000/svg" d="m4.9 2.8l-2.5-2.6c-0.4-0.4-1.1-0.4-1.5 0-0.5 0.5-0.5 1.2 0 1.6l3.3 3.3c0.4 0.4 1.1 0.4 1.5 0l3.3-3.3q0.3-0.4 0.3-0.8c0-0.3-0.1-0.5-0.3-0.8-0.5-0.4-1.1-0.4-1.6 0z"></path>
	</symbol>
	<symbol viewBox="0 0 13 13" id="edit-icon">
		<path xmlns="http://www.w3.org/2000/svg" d="m2.2 2.7q-0.3 0-0.4 0.2-0.2 0.1-0.2 0.4v7.7q0 0.3 0.2 0.4 0.1 0.2 0.4 0.2h7.7q0.2 0 0.4-0.2 0.2-0.1 0.2-0.4v-2.9c0-0.3 0.2-0.6 0.5-0.6 0.3 0 0.6 0.3 0.6 0.6v2.9c0 0.5-0.2 0.9-0.5 1.2q-0.5 0.5-1.2 0.5h-7.7c-0.5 0-0.9-0.2-1.2-0.5q-0.5-0.5-0.5-1.2v-7.7c0-0.5 0.2-0.9 0.5-1.2q0.5-0.5 1.2-0.5h2.9c0.3 0 0.5 0.2 0.5 0.6 0 0.3-0.2 0.5-0.5 0.5zm7.4-2c0.2-0.2 0.5-0.2 0.7 0l2.2 2.2c0.3 0.2 0.3 0.5 0 0.8l-5.5 5.5q-0.1 0.2-0.4 0.2h-2.2c-0.3 0-0.5-0.3-0.5-0.6v-2.2q0-0.2 0.1-0.4zm-4.6 6.2v1.4h1.5l4.9-5-1.4-1.4z"></path>
	</symbol>
	<symbol viewBox="0 0 18 17" id="alarm-icon">
		<path xmlns="http://www.w3.org/2000/svg" d="m7.8 0.9c0.3-0.2 0.8-0.3 1.2-0.3 0.4 0 0.8 0.1 1.2 0.3 0.3 0.2 0.6 0.5 0.8 0.9l6.7 11.1c0.3 0.3 0.4 0.8 0.4 1.2 0 0.3-0.1 0.7-0.4 1.1-0.2 0.3-0.4 0.7-0.8 0.9-0.4 0.2-0.8 0.3-1.2 0.3h-13.4c-0.4 0-0.8-0.1-1.2-0.3-0.4-0.2-0.6-0.6-0.8-0.9-0.3-0.4-0.4-0.8-0.4-1.1 0-0.4 0.1-0.8 0.4-1.2l6.7-11.1 0.7 0.4-0.7-0.4c0.2-0.4 0.5-0.7 0.8-0.9zm0.5 1.7l-6.7 11.1c-0.1 0.1-0.1 0.2-0.1 0.4 0 0.1 0 0.2 0.1 0.3 0.1 0.2 0.2 0.3 0.3 0.4 0.1 0 0.2 0 0.4 0h13.3c0.2 0 0.3 0 0.4 0 0.2-0.1 0.2-0.2 0.3-0.4 0.1-0.1 0.1-0.2 0.1-0.3 0-0.2 0-0.3-0.1-0.4l-6.7-11.1c0-0.1-0.1-0.3-0.3-0.3-0.1-0.1-0.2-0.1-0.4-0.1-0.1 0-0.2 0-0.4 0.1 0 0-0.1 0.1-0.2 0.3z"></path>
	</symbol>
	<symbol viewBox="0 0 5 10" id="arrow-left-icon">
		<path xmlns="http://www.w3.org/2000/svg" d="m4.6 9.1c-0.5 0.4-1 0.4-1.4 0l-2.2-2.2c-0.5-0.5-0.9-1.3-0.8-2.1 0.1-0.8 0.3-1.5 0.8-2.1l2.2-2.1c0.4-0.4 0.9-0.4 1.4 0 0.4 0.4 0.4 1 0 1.4l-2.2 2.1c-0.2 0.2-0.2 0.4-0.2 0.7 0 0.3 0 0.5 0.2 0.7l2.2 2.2c0.4 0.4 0.4 0.9 0 1.4z"></path>
	</symbol>
	<symbol viewBox="0 0 12 13" id="user-icon">
		<path xmlns="http://www.w3.org/2000/svg" d="m1.4 8.5c0.6-0.5 1.4-0.9 2.3-0.9h5c0.8 0 1.7 0.3 2.2 0.9 0.6 0.6 1 1.4 1 2.3v1.2c0 0.4-0.3 0.7-0.6 0.7-0.4 0-0.7-0.3-0.7-0.7v-1.2c0-0.6-0.2-1.1-0.5-1.4-0.4-0.3-0.9-0.5-1.4-0.5h-5c-0.5 0-1 0.1-1.4 0.5q-0.5 0.6-0.5 1.4v1.2c0 0.4-0.3 0.7-0.7 0.7-0.3 0-0.6-0.3-0.6-0.7v-1.2c0-0.9 0.3-1.7 0.9-2.3zm4.8-7.2c-1.1 0-1.9 0.8-1.9 1.9 0 1 0.8 1.9 1.9 1.9 1.1 0 1.9-0.9 1.9-1.9 0-1.1-0.8-1.9-1.9-1.9zm-3.2 1.9c0-1.8 1.4-3.2 3.2-3.2 1.8 0 3.2 1.4 3.2 3.2 0 1.7-1.4 3.1-3.2 3.1-1.8 0-3.2-1.4-3.2-3.1z">
		</path>
	</symbol>
	<symbol viewBox="0 0 1024 1024" id="search-vip-icon">
		<path xmlns="http://www.w3.org/2000/svg" d="M463.401 125.669c-0.629-0.004-1.374-0.007-2.119-0.007-186.734 0-338.112 151.378-338.112 338.112 0 0.767 0.003 1.534 0.008 2.301l-0.001-0.118c-0.004 0.61-0.006 1.332-0.006 2.054 0 186.769 151.407 338.176 338.176 338.176 0.722 0 1.444-0.002 2.166-0.007l-0.111 0.001c0.458 0.002 1.001 0.004 1.543 0.004 88.8 0 169.633-34.11 230.112-89.942l-0.231 0.211c1.792-4.741 4.057-8.841 6.817-12.552l-0.097 0.136c4.548-4.59 9.968-8.307 15.992-10.883l0.328-0.125c53.234-59.688 85.764-138.842 85.764-225.594 0-0.565-0.001-1.129-0.004-1.693v0.087c0.004-0.61 0.006-1.332 0.006-2.055 0-186.734-151.378-338.112-338.112-338.112-0.745 0-1.489 0.002-2.232 0.007l0.114-0.001zM25.961 465.893c-0.003-0.552-0.004-1.206-0.004-1.86 0-240.602 195.046-435.648 435.648-435.648 0.631 0 1.263 0.001 1.893 0.004h-0.097c0.533-0.002 1.165-0.004 1.796-0.004 240.602 0 435.648 195.046 435.648 435.648 0 0.654-0.001 1.307-0.004 1.961v-0.101c0.002 0.446 0.003 0.973 0.003 1.5 0 103.259-35.846 198.146-95.773 272.896l0.667-0.86 177.728 173.632c8.989 8.573 14.578 20.642 14.578 34.016s-5.589 25.443-14.559 33.998l-0.019 0.018c-8.589 8.955-20.652 14.52-34.016 14.52s-25.427-5.565-34-14.504l-0.016-0.016-177.6-173.568c-74.041 59.727-169.275 95.875-272.952 95.875-0.52 0-1.041-0.001-1.561-0.003h0.080c-0.534 0.002-1.165 0.004-1.796 0.004-240.602 0-435.648-195.046-435.648-435.648 0-0.676 0.002-1.352 0.005-2.028v0.104z">
		</path>
	</symbol>
	<symbol viewBox="0 0 16 13" id="menu-icon">
		<path xmlns="http://www.w3.org/2000/svg" d="m0.8 6.7c0-0.5 0.4-0.8 0.9-0.8h12.8c0.6 0 0.9 0.3 0.9 0.8 0 0.6-0.3 0.9-0.9 0.9h-12.8c-0.5 0-0.9-0.3-0.9-0.9zm0-5.3c0-0.5 0.4-0.9 0.9-0.9h12.8c0.6 0 0.9 0.4 0.9 0.9 0 0.5-0.3 0.9-0.9 0.9h-12.8c-0.5 0-0.9-0.4-0.9-0.9zm0 10.7c0-0.5 0.4-0.9 0.9-0.9h12.8c0.6 0 0.9 0.4 0.9 0.9 0 0.5-0.3 0.9-0.9 0.9h-12.8c-0.5 0-0.9-0.4-0.9-0.9z">
		</path>
	</symbol>
	<symbol viewBox="0 0 22 22" id="receipt-icon">
		<path d="M18.2693 6.66V15.34C18.2693 16.67 18.1468 17.615 17.8318 18.2887C17.8318 18.2975 17.823 18.315 17.8143 18.3238C17.6218 18.5688 17.368 18.6912 17.0705 18.6912C16.6068 18.6912 16.0468 18.385 15.4431 17.7375C14.7256 16.9675 13.623 17.0287 12.993 17.8687L12.1093 19.0412C11.7593 19.5137 11.2955 19.75 10.8318 19.75C10.368 19.75 9.90427 19.5137 9.55427 19.0412L8.6618 17.86C8.04055 17.0287 6.94678 16.9675 6.22928 17.7287L6.22052 17.7375C5.23177 18.7962 4.3568 18.9538 3.8493 18.3238C3.84055 18.315 3.83179 18.2975 3.83179 18.2887C3.51679 17.615 3.39429 16.67 3.39429 15.34V6.66C3.39429 5.33 3.51679 4.385 3.83179 3.71125C3.83179 3.7025 3.8318 3.69375 3.8493 3.685C4.34805 3.04625 5.23177 3.20375 6.22052 4.2625L6.22928 4.27125C6.94678 5.0325 8.04055 4.97125 8.6618 4.14L9.55427 2.95875C9.90427 2.48625 10.368 2.25 10.8318 2.25C11.2955 2.25 11.7593 2.48625 12.1093 2.95875L12.993 4.13125C13.623 4.97125 14.7256 5.0325 15.4431 4.2625C16.0468 3.615 16.6068 3.30875 17.0705 3.30875C17.368 3.30875 17.6218 3.44 17.8143 3.685C17.8318 3.69375 17.8318 3.7025 17.8318 3.71125C18.1468 4.385 18.2693 5.33 18.2693 6.66Z" stroke="#292D32" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
		<path d="M7.76929 9.46875H14.7693" stroke="#292D32" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
		<path d="M7.76929 12.5312H13.0193" stroke="#292D32" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
	</symbol>
</svg>
<div class="flex gap-5 mb-4">
	<div class="min-w-[279px] max-w-[279px] sidebar-panel" id="menu-panel">
		<div class="filter cursor-pointer fixed left-[15px] bottom-5 bg-[#f73148] rounded-[7px] w-10 h-10  hidden items-center justify-center shadow-[-3px_3px_6px_#0219591a] a-md:flex z-[99]" id="open-menu-panel">
			<div class="button-filter flex flex-col items-center">
				<span class="icn inline-block">
					<svg class="fill-white w-5 h-5">
						<use xlink:href="#menu-icon">
						</use>
					</svg>
				</span>
			</div>
			<!-- .button-filter -->
		</div>
		<?php
		/**
		 * My Account navigation.
		 *
		 * @since 2.6.0
		 */
		do_action('woocommerce_account_navigation'); ?>
	</div>
	<div class="woocommerce-MyAccount-content grow border border-[#f2f4f7] p-7 rounded-[9px] tab:p-4">
		<?php
		/**
		 * My Account content.
		 *
		 * @since 2.6.0
		 */
		do_action('woocommerce_account_content');
		?>
	</div>
</div>