<?php

/**
 * My Addresses
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */

defined('ABSPATH') || exit;

$customer_id = get_current_user_id();

if (!wc_ship_to_billing_address_only() && wc_shipping_enabled()) {
	$get_addresses = apply_filters(
		'woocommerce_my_account_get_addresses',
		array(
			'billing'  => __('Billing address', 'woocommerce'),
			'shipping' => __('Shipping address', 'woocommerce'),
		),
		$customer_id
	);
} else {
	$get_addresses = apply_filters(
		'woocommerce_my_account_get_addresses',
		array(
			'billing' => __('Billing address', 'woocommerce'),
		),
		$customer_id
	);
}

$oldcol = 1;
$col    = 1;
?>

<div class="flex items-center justify-between border-[#f2f4f7] border-b pb-6 mb-8 tab:mb-4 tab:pb-4">
	<span class="text-[17px] text-[#768699] font-bold tab:text-[15px]">تنظیمات آدرس</span>
</div>

<?php if (!wc_ship_to_billing_address_only() && wc_shipping_enabled()) : ?>
	<div class="u-columns woocommerce-Addresses col2-set addresses grid grid-cols-2 gap-9 tab:grid-cols-1">
	<?php endif; ?>

	<?php foreach ($get_addresses as $name => $address_title) : ?>
		<?php
		$address = wc_get_account_formatted_address($name);
		$col     = $col * -1;
		$oldcol  = $oldcol * -1;
		?>

		<div class="u-column<?php echo $col < 0 ? 1 : 2; ?> col-<?php echo $oldcol < 0 ? 1 : 2; ?> woocommerce-Address">
			<header class="woocommerce-Address-title title flex items-center justify-between mb-8">
				<h2 class='text-[14px] text-[#575656] font-bold'><?php echo esc_html($address_title); ?></h2>
				<a href="<?php echo esc_url(wc_get_endpoint_url('edit-address', $name)); ?>" class="edit text-[13px] text-[#969fae] font-bold flex items-center gap-2">
					<?php
					printf(
						/* translators: %s: Address title */
						$address ? esc_html__('ویرایش', 'woocommerce') : esc_html__('اضافه کردن %s', 'woocommerce'),
						esc_html($address_title)
					);
					?>
					<svg class="fill-[#969fae] w-3 h-3">
						<use xlink:href="#edit-icon">
						</use>
					</svg>
				</a>
			</header>
			<address class="pr-5 border-r border-[#E6ECF9] text-[13px] not-italic font-bold">
				<?php
				echo $address ? wp_kses_post($address) : esc_html_e('You have not set up this type of address yet.', 'woocommerce');

				/**
				 * Used to output content after core address fields.
				 *
				 * @param string $name Address type.
				 * @since 8.7.0
				 */
				do_action('woocommerce_my_account_after_my_address', $name);
				?>
			</address>
		</div>

	<?php endforeach; ?>

	<?php if (!wc_ship_to_billing_address_only() && wc_shipping_enabled()) : ?>
	</div>
<?php
	endif;
