<?php

/**
 * Display single product reviews (comments)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product-reviews.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.3.0
 */

defined('ABSPATH') || exit;

global $product, $shopi_options;
if (!comments_open()) {
	return;
}
?>
<div id="reviews" class="woocommerce-Reviews">
	<div class="flex items-center gap-9 mb-8 a-md:gap-3 a-md:flex-wrap a-md:mb-4">
		<span class='title-content-tab text-[20px] text-[#495666] font-bold a-md:text-[16px]'>نظرات کاربران</span>
		<ul class="flex items-center gap-7 grow list-tab-comment a-md:gap-3 a-md:order-3 tab:w-full">
			<li><a href="<?= add_query_arg('sort', 'newest') ?>" class='text-[14px] text-[#a2acb7] font-bold item a-md:text-[13px] <?= isset($_GET['sort']) && $_GET['sort'] == 'newest' ? 'active' : '' ?>'>جدیدترین
					ها</a></li>
			<li><a href="<?= add_query_arg('sort', 'popular') ?>" class='text-[14px] text-[#a2acb7] font-bold item a-md:text-[13px] <?= isset($_GET['sort']) && $_GET['sort'] == 'popular' ? 'active' : '' ?>'>محبوبترین
					ها</a></li>
		</ul>
		<svg class='fill-[#969fae] w-[14px] h-[14px] mr-auto'>
			<use xlink:href='#comment'>
		</svg>
	</div>
	<?php if (get_option('woocommerce_review_rating_verification_required') === 'no' || wc_customer_bought_product('', get_current_user_id(), $product->get_id())) : ?>
		<div id="review_form_wrapper">
			<div id="review_form" class="border border-[#e9edf2] rounded-[9px] px-10 py-11 mb-5 a-lg:p-6 a-sm:px-4">
				<?php
				$commenter    = wp_get_current_commenter();
				$comment_form = array(
					'title_reply'         => '',
					'comment_notes_after' => '',
					'label_submit'        => esc_html__('Submit', 'woocommerce'),
					'logged_in_as'        => '',
					'comment_field'       => '',
				);

				$name_email_required = (bool) get_option('require_name_email', 1);
				$fields              = array(
					'author' => array(
						'label'    => __('Name', 'woocommerce'),
						'type'     => 'text',
						'value'    => $commenter['comment_author'],
						'required' => $name_email_required,
						'svg' => '<svg class="fill-[#969fae] w-[11px] h-[13px]">
                                                <use xlink:href="#user-icon">
                                            </use></svg>'
					),
					'email'  => array(
						'label'    => __('Email', 'woocommerce'),
						'type'     => 'email',
						'value'    => $commenter['comment_author_email'],
						'required' => $name_email_required,
						'svg' => '<svg class="fill-[#969fae] w-[11px] h-[13px]">
                                                <use xlink:href="#mobile-icon">
                                            </use></svg>'
					),
				);

				$comment_form['fields'] = array();

				foreach ($fields as $key => $field) {
					$field_html  = '<p class="comment-form-' . esc_attr($key) . '">';
					$field_html .= '<label class="hidden" for="' . esc_attr($key) . '">' . esc_html($field['label']);

					if ($field['required']) {
						$field_html .= '&nbsp;<span class="required">*</span>';
					}

					$field_html .= '</label>' . $field['svg'] . '<input id="' . esc_attr($key) . '" placeholder="' . esc_html($field['label']) . '" name="' . esc_attr($key) . '" type="' . esc_attr($field['type']) . '" value="' . esc_attr($field['value']) . '" size="30" ' . ($field['required'] ? 'required' : '') . ' /></p>';

					$comment_form['fields'][$key] = $field_html;
				}

				$account_page_url = wc_get_page_permalink('myaccount');
				if ($account_page_url) {
					/* translators: %s opening and closing link tags respectively */
					// $comment_form['must_log_in'] = '<p class="must-log-in">' . sprintf(esc_html__('You must be %1$slogged in%2$s to post a review.', 'woocommerce'), '<a href="' . esc_url($account_page_url) . '">', '</a>') . '</p>';
				}
				if (wc_review_ratings_enabled()) {
					if (!empty($shopi_options['list_comment_rate']['redux_repeater_data'])) {
						$info_rate = get_average_comment_post($product->get_id());
						$i = 1;
						$star_num = (int)round_special($info_rate->avg);
						$comment_form['comment_field'] = "<div class='box-rating'>
                                            <div class='flex items-center justify-between mb-12 a-sm:mb-4'>
                                                <div class='flex items-center gap-3'>
                                                    <ins
                                                        class='text-[50px] text-secondary_text  font-bold leading-[0.5] mt-3'>" . @$star_num . "</ins>
                                                    <div>
                                                        <span class='text-[12px] text-[#969fae] font-bold mb-1'>امتیاز
                                                            محصول</span>
                                                        <div class='flex items-center gap-[2px]'>
															<svg class='w-[14px] h-[14px] " . ($star_num >= 1 ? "fill-secondary_fill" : "fill-[#bbb6ac]") . "'>                                                               
															 <use xlink:href='#star-icon'>
                                                            </svg>
															<svg class='w-[14px] h-[14px] " . ($star_num >= 2 ? "fill-secondary_fill" : "fill-[#bbb6ac]") . "'>                                                               
                                                                <use xlink:href='#star-icon'>
                                                            </svg>
															<svg class='w-[14px] h-[14px] " . ($star_num >= 3 ? "fill-secondary_fill" : "fill-[#bbb6ac]") . "'>                                                               
                                                                <use xlink:href='#star-icon'>
                                                            </svg>
															<svg class='w-[14px] h-[14px] " . ($star_num >= 4 ? "fill-secondary_fill" : "fill-[#bbb6ac]") . "'>                                                               
                                                                <use xlink:href='#star-icon'>
                                                            </svg>
															<svg class='w-[14px] h-[14px] " . ($star_num >= 5 ? "fill-secondary_fill" : "fill-[#bbb6ac]") . "'>                                                               
                                                                <use xlink:href='#star-icon'>
                                                            </svg>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class='flex flex-col w-max'>
                                                    <span class='text-[12px] text-[#969fae] font-bold'>از مجموع</span>
                                                    <div class='flex items-center justify-between'>
                                                        <span class='text-[16px] text-secondary_text  font-bold'>" . @$info_rate->count . "</span>
                                                        <span class='text-[12px] text-[#969fae] font-bold'>رای</span>
                                                    </div>
                                                </div>
                                            </div>";
						$comment_form['comment_field'] .=   "<div class='flex flex-col gap-6 a-md:grid a-md:grid-cols-2 a-md:gap-3'>";
						foreach ($shopi_options['list_comment_rate']['redux_repeater_data'] as $key =>  $item) {
							$_item = $shopi_options['list_comment_rate'];
							$title   = isset($_item['title'][$key]) ? $_item['title'][$key] : '';

							$comment_form['comment_field'] .= "<div class='flex flex-col gap-4'>
                                                    <span class='text-[14px] text-[#8f9aa8] font-bold'>" . $title . "</span>
                                                    <span class='slider' class='w-16'></span>
                                                    <input type='hidden' name='rate_count_" . $i . "'>
                                                </div>";
							$i++;
						}

						$comment_form['comment_field'] .=   "</div>";
						$comment_form['comment_field'] .=   "</div>";
					}
				}
				$comment_form['comment_field'] .= '<p class="comment-form-comment"><label class="hidden"  for="comment">' . esc_html__('Your review', 'woocommerce') . '&nbsp;<span class="required">*</span></label><textarea id="comment" name="comment" placeholder="متن دیدگاه خود را بنویسید" cols="45" rows="8" required></textarea></p>';

				comment_form(apply_filters('woocommerce_product_review_comment_form_args', $comment_form));
				?>
			</div>
		</div>
	<?php else : ?>
		<p class="woocommerce-verification-required"><?php esc_html_e('Only logged in customers who have purchased this product may leave a review.', 'woocommerce'); ?></p>
	<?php endif; ?>

	<div id="comments">
		<?php if (have_comments()) : ?>
			<ol class="commentlist">
				<?php wp_list_comments(apply_filters('woocommerce_product_review_list_args', array('callback' => 'woocommerce_comments'))); ?>
			</ol>

			<?php
			if (get_comment_pages_count() > 1 && get_option('page_comments')) :
				echo '<nav class="woocommerce-pagination">';
				paginate_comments_links(
					apply_filters(
						'woocommerce_comment_pagination_args',
						array(
							'prev_text' => is_rtl() ? '&rarr;' : '&larr;',
							'next_text' => is_rtl() ? '&larr;' : '&rarr;',
							'type'      => 'list',
						)
					)
				);
				echo '</nav>';
			endif;
			?>
		<?php else : ?>
			<div class="no-comment-box flex flex-col items-center justify-center h-[341px] bg-white rounded-[9px]  border-[1px] border-[#e9eef4] mb-[25px] tab:h-[140px]">
				<div class="w-max">
						<span class="text-[23px] text-[#6c6c6c] leading-[30px] font-bold text-center">
							هنـوز دیدگاهی ثبــت نشــده
						</span>

						<span class="text-[13px] text-[#9fafc5] table w-max mr-auto">
							اولیــن باشــید شــما
						</span>
				</div>
			</div>
		<?php endif; ?>
	</div>

	<div class="clear"></div>
</div>