<?php

/**
 * Single variation cart button
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined('ABSPATH') || exit;

global $product;
?>
<div class="woocommerce-variation-add-to-cart variations_button">
	<?php do_action('woocommerce_before_add_to_cart_button'); ?>

	<div class="quantity border border-[#e9edf2] rounded-[10px] flex items-stretch justify-between mb-4 tab:mb-2 <?= $product->get_min_purchase_quantity()  == 1  && $product->get_max_purchase_quantity() == 1  ? 'hidden' : '' ?>">
		<button class="flex items-center justify-center plus px-6">
			<svg class="fill-[#28313b] w-[11px] h-[11px]">
				<use xlink:href="#plus-icon">
				</use>
			</svg>
		</button>

		<?php
		do_action('woocommerce_before_add_to_cart_quantity');

		woocommerce_quantity_input(
			array(
				'min_value'   => apply_filters('woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product),
				'max_value'   => apply_filters('woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product),
				'input_value' => isset($_POST['quantity']) ? wc_stock_amount(wp_unslash($_POST['quantity'])) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
				'classes' => 'input-text qty text text-[18px] text-[#28313b] font-bold grow text-center focus:outline-none py-3 max-w-[30px]'
			)
		);

		do_action('woocommerce_after_add_to_cart_quantity');
		?>
		<button class="flex items-center justify-center minus px-6">
			<svg class="fill-[#28313b] w-[11px] h-[3px]">
				<use xlink:href="#minus-icon">
				</use>
			</svg>
		</button>
	</div>

	<button type="submit" class="single_add_to_cart_button button alt bg-secondary_bg rounded-[9px] flex items-center justify-between px-6 py-[18px] text-[20px] text-[#ffffff] font-bold w-full transition-3s button alt<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>"><?php echo esc_html($product->single_add_to_cart_text()); ?><svg class="fill-white w-[14px] h-[14px] transition-3s">
			<use xlink:href="#plus-icon">
			</use>
		</svg></button>

	<?php do_action('woocommerce_after_add_to_cart_button'); ?>

	<input type="hidden" name="add-to-cart" value="<?php echo absint($product->get_id()); ?>" />
	<input type="hidden" name="product_id" value="<?php echo absint($product->get_id()); ?>" />
	<input type="hidden" name="variation_id" class="variation_id" value="0" />
</div>