<?php

/**
 * Product attributes
 *
 * Used by list_attributes() in the products class.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-attributes.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */

defined('ABSPATH') || exit;

if (!$product_attributes) {
	return;
}
?>
<table class="woocommerce-product-attributes shop_attributes list w-full" aria-label="<?php esc_attr_e('Product Details', 'woocommerce'); ?>">
	<tbody class="flex flex-col gap-[18px] a-sm:gap-2">
		<?php foreach ($product_attributes as $product_attribute_key => $product_attribute) : ?>
			<tr class="woocommerce-product-attributes-item woocommerce-product-attributes-item--<?php echo esc_attr($product_attribute_key); ?> flex items-stretch gap-3">
				<th class="woocommerce-product-attributes-item__label text-[14px] text-[#969fae] font-bold bg-[#f8f9fb] rounded-[10px] py-5 px-6 max-w-[224px] min-w-[224px] a-sm:p-2 a-sm:px-3 a-sm:text-[13px] a-sm:min-w-[140px]" scope="row"><?php echo wp_kses_post($product_attribute['label']); ?></th>
				<td class="woocommerce-product-attributes-item__value text-[14px] text-[#708189] font-bold bg-[#f8f9fb] rounded-[10px] py-5 px-6 grow a-sm:p-2 a-sm:px-3 a-sm:text-[13px]"><?php echo wp_kses_post($product_attribute['value']); ?></td>
			</tr>
		<?php endforeach; ?>
	</tbody>
</table>