<?php

/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.0.0
 */


if (!defined('ABSPATH')) {
	exit;
}

if (!function_exists('wc_get_gallery_image_html')) {
	return;
}
global $post, $woocommerce, $product, $wd_data;
$attachment_ids = $product->get_gallery_image_ids();
array_unshift($attachment_ids, get_post_thumbnail_id());
$loop 		= 0;
$columns 	= apply_filters('woocommerce_product_thumbnails_columns', 3);
?>
<div class="">
	<?php if (!in_array("0", $attachment_ids)) { ?>
		<div class="box-gallery-main border border-[#f2f4f7] rounded-[9px] p-6 pt-11 px-14 h-[435px] mb-7 tab:p-3 tab:pt-5 tab:mb-3 tab:h-[300px]">
			<div class="swiper swiper-gallery h-full">
				<div class="swiper-wrapper">
					<?php
					$numimg = 1;
					foreach ($attachment_ids as $attachment_id) {
						$classes = array();
						$atr = '';
						if ($loop == 0 || $loop % $columns == 0)
							$classes[] = 'first';
						$atr = 'data-skip-lazy=""';

						if (($loop + 1) % $columns == 0)
							$classes[] = 'last';

						if (wp_is_mobile()) {
							$size = 'full';
						} else {
							$size = 'full';
						}
						$image_link = wp_get_attachment_image_src($attachment_id, $size)['0'];
						$image_width  = wp_get_attachment_image_src($attachment_id, $size)['1'];
						$image_height = wp_get_attachment_image_src($attachment_id, $size)['2'];
						if (!$image_link)
							continue;
						$classes[] = 'object-cover';
						$image_class = esc_attr(implode(' ', $classes));
						$image_alt = get_post_meta($attachment_id, '_wp_attachment_image_alt', true);
						echo apply_filters('woocommerce_single_product_image_thumbnail_html', sprintf('<div class="swiper-slide flex items-center justify-center" data-id="%s"><a class="glightbox h-full" href="%s"><img class="object-contain !h-full w-full" src="%s"  width="%s" height="%s" alt="%s" loading="lazy" ' . $atr . '></a></div>', $attachment_id, $image_link, $image_link, $image_width, $image_height, $image_alt), $attachment_id, $post->ID, $image_class);
						$loop++;
						$numimg++;
					}
					?>
				</div>
				<div class="swiper-pagination"></div>
			</div>
		</div>
	<?php if ($numimg > 2) {
			do_action('woocommerce_product_thumbnails');
		}
	} else {
		echo '<div class="woocommerce-product-gallery__image--placeholder">';
		echo wc_placeholder_img('woocommerce_single');
		echo '</div>';
	}
	?>
</div>