<?php

/**
 * Single Product Thumbnails
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-thumbnails.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.5.1
 */

defined('ABSPATH') || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if (!function_exists('wc_get_gallery_image_html')) {
	return;
}

global $post, $product, $woocommerce, $wd_data;
$attachment_ids = $product->get_gallery_image_ids();
array_unshift($attachment_ids, get_post_thumbnail_id());
if ($attachment_ids) {
	$loop 		= 0;
	$columns 	= apply_filters('woocommerce_product_thumbnails_columns', 3);
?>
	<div class="box-swiper-gallery-thumb">
		<div class="swiper swiper-gallery-thumb  <?php echo 'columns-' . $columns; ?>">
			<div class="swiper-wrapper">
				<?php
				foreach ($attachment_ids as $attachment_id) {
					$classes = array();
					if ($loop == 0 || $loop % $columns == 0)
						$classes[] = 'first';

					if (($loop + 1) % $columns == 0)
						$classes[] = 'last';
					$image_n_url = wp_get_attachment_image_src($attachment_id, 'thumbnail');
					$image_link = wp_get_attachment_image_src($attachment_id, 'thumbnail')[0];
					$image_n_url_w = $image_n_url[1];
					$image_n_url_h = $image_n_url[2];
					if (!$image_link)
						continue;

					$image_class = esc_attr(implode(' ', $classes));
					$image_alt = get_post_meta($attachment_id, '_wp_attachment_image_alt', true);
					echo apply_filters('woocommerce_single_product_image_thumbnail_html', sprintf('<div class="item swiper-slide flex items-center justify-center !w-[68px] !h-[66px] rounded-[10px] p-2 bg-[#f8f9fb] cursor-pointer "  data-id="%s"><img class="object-contain object-contain w-full h-full" src="%s" width="%s" height="%s" alt="%s" loading="lazy"></div>', $attachment_id, $image_link, $image_n_url_w, $image_n_url_h, $image_alt, $image_class), $attachment_id, $post->ID, $image_class);
					$loop++;
				}
				?>
			</div>
		</div>
	</div>
<?php
}
