<?php

/**
 * Review Comments Template
 *
 * Closing li is left out on purpose!.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/review.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 2.6.0
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
?>
<li <?php comment_class(''); ?> id="li-comment-<?php comment_ID(); ?>">
	<div id="comment-<?php comment_ID(); ?>" class="comment_container content-wrap border border-[#e9edf2] rounded-[9px] p-11 mb-7 a-md:p-4 a-md:mb-3">
		<div class="flex items-center gap-8 mb-7 a-md:mb-4">
			<span class="comment_author text-[18px] text-[#495666] font-bold"><?= $comment->comment_author ?></span>
			<span class="comment_date text-[13px] text-[#969fae] font-bold">
				<?= date_i18n('l j F Y', strtotime($comment->comment_date)) ?>
			</span>
		</div>
		<p class="comment_content text-[14px] text-[#495666] font-bold text-justify leading-[2.2] mb-6 a-md:text-[13px] a-md:leading-[2] a-md:mb-4">
			<?= $comment->comment_content ?>
		</p>
		<div class="flex items-center">
			<?php comment_reply_link(array_merge($args, array('reply_text' => '<span class="comment_reply_link text-[14px] text-[#969fae] font-bold a-md:text-[13px]">پاسخ دهید</span>', 'depth' => $depth, 'max_depth' => $args['max_depth']))) ?> </span>
			<div class="flex items-center mr-auto gap-5 CommentLike cursor-pointer" data-id="<?php comment_ID(); ?>">
				<span class="like-btn text-[14px] text-[#969fae] font-bold flex items-center gap-3 a-md:text-[13px] item-show-rating-comment">
					<svg class="fill-secondary_fill w-[14px] h-[14px]">
						<use xlink:href="#like">
						</use>
					</svg>
					بله
				</span>
				<span class="box-status-like text-[14px] text-[#969fae] font-bold a-md:text-[13px] flex items-center gap-2">
					<span class="text-defult"> مفید بود </span>
					<span class="hidden text-active">
						ثبت شد ، تشکر
					</span>
					<span class="flex items-center gap-1"> [ <span class="like-count"><?= count_comment_like($comment->comment_ID) ?></span> ] </span>
				</span>

			</div>
		</div>
		<?php if (is_singular('product')) {
			$rating_option = get_comment_meta($comment->comment_ID, 'rating_option', true);
			$rating = get_comment_meta($comment->comment_ID, 'rating', true);
			if (isset($rating_option) && !empty($rating_option) && is_array($rating_option)) {
		?>
				<div class="flex items-center justify-between gap-7 pt-10 mt-8 border-t border-[#e9edf2] a-sm:pt-4 a-sm:mt-4 ml:gap-3 a-md:grid grid-cols-2">
					<?php foreach ($rating_option as $item) { ?>
						<div class="flex flex-col gap-4 items-center flex-1 a-sm:gap-2">
							<span class="text-[12px] text-[#9ea7b0] font-bold"><?= $item['title'] ?></span>
							<span class="bg-[#d3dae5] h-[2px] w-full flex overflow-hidden a-sm:h-3">
								<span class="bg-secondary_bg inline-block" style="width: <?= $item['count'] * 20 ?>%;"></span>
							</span>
						</div>
					<?php } ?>
					<div class="flex items-center gap-5 a-sm:col-span-2 a-sm:justify-center">
						<span class="text-[12px] text-[#969fae] font-bold text-center">مجموع
							<br>امتیاز</span>
						<ins class="text-[50px] text-secondary_text  font-bold leading-[1]"><?= @$rating ?></ins>
					</div>
				</div>
		<?php }
		} ?>
	</div>